{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

{if isset($smarty.get.recipe) && !empty($smarty.get.recipe)}
	{assign var=recipe value=$smarty.get.recipe}
{else}
	{assign var=recipe value=''}
{/if}

{fetch_products perPage=16 assign=products category=$section.sectionId section=$section.sectionId query=$query recipe=$recipe assignPagination=pagination page=$page path=$section.path seFriendly=true}

<main class="main">

	<div class="flex:col">
		<div class="flex:col-max">
			{* breadcrumb *}
			{include file="modules/breadcrumb.tpl" class="bradcrumbs" boldLastItem=false noLastLink=true}
			{* /breadcrumb *}
		</div>
	</div>

	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-30">
				<div class="block-head">
					<div class="text-tmp title-40"><h1>{$section.name}</h1></div>
				</div>

				<div class="catalog">

					<aside class="catalog__aside">
						<div class="text-tmp title-20"><h3>Нозология</h3></div>
						<nav class="catalog__nav">
							<ul>
								{fetch_sections assign=catalogSections from=3 status="V"}
								{foreach item=subcatalog from=$catalogSections name=catalogSections}
									<li><a class="{if $subcatalog.sectionId eq $section.sectionId}active{/if}" href="{$SITE_URL}{$subcatalog.url}">{$subcatalog.alias}</a></li>
								{/foreach}
							</ul>
						</nav>
					</aside>

					<div class="catalog__content">
						<div class="grid:fr-4 max g-gap-20">
							{foreach item=product from=$products name=products key=key}
								{* item product *}
								{include file="items/product.tpl"}
								{* /item product *}
							{/foreach}
						</div>

						{include file="modules/pagination.tpl" class="pagination x-center"}
					</div>
				</div>
			</div>
		</div>
	</section>

	{* Call центр *}
	{include file="blocks/call-center.tpl"}
	{* /Call центр *}

	{* Подписаться на Рассылку *}
	{include file="blocks/newsletter.tpl"}
	{* /Подписаться на Рассылку *}

</main>

{include file="footer.tpl"}