{include file="header.tpl" title=$product.title keywords=$product.keywords description=$product.description}

<main class="main">

	<div class="flex:col">
		<div class="flex:col-max">
			{* breadcrumb *}
			{include file="modules/breadcrumb.tpl" class="bradcrumbs" boldLastItem=false noLastLink=true}
			{* /breadcrumb *}
		</div>
	</div>

	<section class="flex:col pad-tb-50">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-30">
				<div class="product">

					<div class="product__item">
						{* основная картинка *}
						<div class="product__img"><img src="{$product.image.original}" alt="{$product.title}"></div>
						{* /основная картинка *}

						{* Скачать PDF инструкцию *}
						{if !empty($product.docs)}
							{assign var=doc value=$product.docs|first}
							<a class="btn accent-3 full" href="{$doc.original}" target="blank_">Скачать PDF инструкцию</a>
						{/if}
						{* /Скачать PDF инструкцию *}
					</div>

					<div class="product__item">
						{* Заголовок *}
						<div class="text-tmp title-24 mar-all-10 txt-fw-500"><h1>{$product.title}</h1></div>
						{* /Заголовок *}

						{* Категории *}
						{if !empty($product.categoryIds)}
							<div class="text-tmp title-18 mar-all-10 txt-fw-500">
								<h2>Категория:</h2>
								<p>
									{fetch_sections assign=catalogSections sections=$product.categoryIds status="V"}
									{foreach item=subcatalog from=$catalogSections name=catalogSections}
										<a href="{$SITE_URL}{$subcatalog.url}">{$subcatalog.alias}</a>
									{/foreach}
								</p>
							</div>
						{/if}
						{* /Категории *}

						{* Описание *}
						{if !empty($product.summary)}
							<div class="text-tmp title-18 mar-all-10 txt-fw-500">
								<h2>Описание:</h2>
								{$product.summary nofilter}
							</div>
						{/if}
						{* /Описание *}

						{* accordion *}
						{if is_array($product.content)}
							<div class="accard tab_js accard_js">
								{foreach from=$product.content item=content}
									<div class="accard__item">
										<button class="accard__btn tab-btn_js">{$content.name nofilter}</button>
										<div class="accard__drop tab-drop_js">
											<div class="accard__drop-inner">
												<div class="text-tmp title-18 mar-all-10 txt-fw-500">{$content.description nofilter}</div>
											</div>
										</div>
									</div>
								{/foreach}
							</div>
						{/if}
						{* /accordion *}

					</div>
				</div>
			</div>
		</div>
	</section>

	{* Похожие продукты *}
	{fetch_product_related limit=10 assign=product_relateds productId=$product.productId}{if !empty($product_relateds)}
		<section class="flex:col pad-tb-50">
			<div class="flex:col-max">
				<div class="grid:fr-1 g-gap-30">
					<div class="block-head">
						<div class="text-tmp title-40"><h2>Похожие продукты</h2></div>
					</div>
					<div class="grid:fr-4 g-gap-20">
						{foreach from=$product_relateds item=related}
							{* item product *}
							{include file="items/product.tpl"}
							{* /item product *}
						{/foreach}
					</div>
				</div>
			</div>
		</section>
	{/if}
	{* /Похожие продукты *}

	{* Call центр *}
	{include file="blocks/call-center.tpl"}
	{* /Call центр *}

	{* Подписаться на Рассылку *}
	{include file="blocks/newsletter.tpl"}
	{* Подписаться на Рассылку *}

</main>

{include file="footer.tpl"}