<?php
	include '../includes/overall.inc.php';

use Mnv\Core\Config;
use Mnv\Core\Feedback;
use Mnv\Core\Locale\I18N;
use Mnv\Core\Validations\Exceptions\InvalidEmailException;
use Mnv\Core\Validations\ValidateEmail;

if (request()->ajax()) {

    $feedbackClass = new Feedback();

    $error    = '';
    $response  = null;
    $captchaGood = false;
    $attachment = null;

    $rewrite   = request()->get('rewrite');
    $feedback  = request()->get('feedback');
    $recaptcha_token        = request()->get('recaptcha_token');
    $g_recaptcha_response   = request()->get('g-recaptcha-response');
    $bot                    = request()->get('bot');

    if (request()->hasFile('file')) {
        $attachment = request()->files->get('file');
    }

    if ($rewrite != Config::getValue('rewrite')) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: " . SITE_URL);

        exit;
    }

    if (empty($feedback['subject'])) {
        $feedback['subject'] = Config::getValue('smtp_subject');
    }
    $feedback['subject'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['subject']));

    if (!empty($feedback['fullName'])) {
        $feedback['fullName'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['fullName']));
        $feedbackClass->checkName($feedback['fullName']);
    } else {
        $feedbackClass->message = I18N::locale("Поле не должно быть пустым", "Maydon bo'sh bo'lmasligi kerak", "The field should not be empty");
        $feedbackClass->errors = 'fullName';
    }

    $arrayMessage = array_filter([
        'Дата отправки сообщения' => adjustTime(gmdate('d-m-Y H:i'), false, 'd-m-Y H:i'),
        'Ф.И.О.'            => $feedback['fullName'],
        'Телефон'           => $feedback['phone'] ?? null,
        'Е-майл'            => $feedback['email'] ?? null,
        'Вакансия'          => $feedback['vacancy'] ?? null,
        'Сообщение'         => $feedback['message'] ?? null,
    ]);

    $htmlBody = '';
    foreach($arrayMessage as $key => $value) {
        $htmlBody .= "<b>".$key.":</b> ".$value."<br />";
    }

    if (empty($feedbackClass->errors)) {
        if ($feedbackClass->getCaptchaEnabled() == 1) {
            if ($feedbackClass->getAllowCaptcha() == 1 &&  !empty($bot)) {
                if ($feedbackClass->antiBot($bot)) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->message,'errors' => $feedbackClass->errors,  'color' => 'red');
                }
            } elseif ($feedbackClass->getAllowCaptcha() == 2) {
                if ($feedbackClass->validateReCaptchaV2($g_recaptcha_response)) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->message, 'errors' => $feedbackClass->errors, 'color' => 'red');
                }
            }
            elseif ($feedbackClass->getAllowCaptcha() == 3) {
                if ($feedbackClass->validateReCaptchaV3($recaptcha_token)) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->message,'errors' => $feedbackClass->errors, 'color' => 'red');
                }
            }
        }

        /* если все good, то пропускаем на отправку */
        if (empty($feedbackClass->errors) && $captchaGood) {

            $feedbackClass->send_telegram('feedback_', ["#" .$feedback['subject'], $feedback]);

            /* отправка по smtp */
            if (empty($feedbackClass->errors)) {
               if ($feedbackClass->send($feedback['email'] ?? null, $feedback['fullName'], $feedback['subject'], $htmlBody, $attachment)) {
                   $response = array('status' => 200, 'type' => 'success', 'message' => I18N::locale("Ваше сообщение успешно отправлено", "Sizning xabaringiz muvaffaqiyatli yuborildi", "Your message has been sent successfully"));
                    $feedbackClass->insertMail($feedback, $htmlBody);
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->message, 'error' => $feedbackClass->errors, 'type' => 'error');
                }
            } else {
                $response = array('status' => 400, 'message' => $feedbackClass->message, 'error' => $feedbackClass->errors,  'type' => 'error');
            }
        }

    } else {
        $response = array('status' => 400, 'message' => $feedbackClass->message, 'error' => $feedbackClass->errors, 'type' => 'error');
    }

    return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

} else {
    die('Hacking attempt!');
}


  

