<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

function smarty_function_fetch_sections($params, &$smarty) {
	global $SECTIONS;

	$assign     = fetch_getParam('assign', $params, 'sections');
	$fields     = fetch_getParam('fields', $params, 'sectionId, parentId, name, alias, url, content');
	$status     = fetch_getParam('status', $params, 'V');
	$from       = fetch_getParam('from', $params, NULL);
	$level      = (int) fetch_getParam('level', $params, 0);
	$type       = fetch_getParam('type', $params, '');
	$limit      = (int) fetch_getParam('limit', $params);
    $topMenu    = (int) fetch_getParam('topMenu', $params);
    $footerMenu = (int) fetch_getParam('footerMenu', $params);
    $showMainPage = (int) fetch_getParam('showMainPage', $params);
    $enableIndex = (int) fetch_getParam('enableIndex', $params);
	$sections   = fetch_getParam('sections', $params, NULL);
	$parents    = fetch_getParam('parents', $params, NULL);
	$getContent = (bool) fetch_getParam('getContent', $params, false);

	$image      = fetch_getParam('image', $params, false);
    $imageType  = fetch_getParam('imageType', $params, 'general');

	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_sections: "assign" must not be empty');
		return;
	}

	if (!is_null($sections)) {
		$sectionIds = array();
		if (!is_array($sections)){
			$sections = explode(',', $sections);
			$sections = array_map('trim', $sections);
		}
		$sectionIds = $sections;

		foreach ($SECTIONS as $sectionId => $section) {
			if (($key = array_search($section['dir'], $sectionIds, true))
                || ($key = array_search($section['fileName'], $sectionIds, true))
                || ($key = array_search($section['sectionId'], $sectionIds, true))) {
				$sectionIds[$key] = $section['sectionId'];
			}
		}

		foreach ($sectionIds as $key => $sectionId) {
            $result[$sectionId] = $key;
        }
	}

    /** получение всех подразделов при массиве parents */
    if (!is_null($parents)) {
        $parentIds = array();
        if (!is_array($parents)){
            $parents = explode(',', $parents);
            $parents = array_map('trim', $parents);
        }
        foreach ($SECTIONS as $section) {
            if (in_array($section['sectionId'], $parents, true)) {
                $parentIds[] = $section['children'];
            }
        }
        $parentIds = array_merge([], ...$parentIds);

        foreach ($parentIds as $key => $sectionId) {
            $result[$sectionId] = $key;
        }
    }


    /** получение всех подразделов */
	if (!is_null($from)) {
		if (is_numeric($from) && (($from == 0) || !empty($SECTIONS[$from]))) {
			$parentId = $from;
		} else {
			foreach ($SECTIONS as $sectionId => $section) {
				if ($section['dir'] == $from) {
					$parentId = $sectionId;
					break;
				}
			}
		}
	}


	$total = 0;
	$result = array();
	foreach ($SECTIONS as $sectionId => $section) {
		if (!empty($limit) && $total >= $limit) break;
		if (isset($sectionIds) && !in_array($section['sectionId'], $sectionIds)) continue;
		if (isset($parentIds) && !in_array($section['sectionId'], $parentIds)) continue;
		if (!empty($parentId) && $section['parentId'] != $parentId) continue;
		if (!empty($level) && $section['level']       != $level) continue;
		if (!empty($status) && $section['status']     != $status) continue;
        if (!empty($topMenu) && $section['topMenu']   != $topMenu) continue;
        if (!empty($footerMenu) && $section['footerMenu'] != $footerMenu) continue;
        if (!empty($showMainPage) && $section['showMainPage'] != $showMainPage) continue;
        if (!empty($enableIndex) && $section['enableIndex'] != $enableIndex) continue;
		if (!empty($type) && $section['type']         != $type) continue;
		$result[$sectionId] = $section;
		$total++;
	}

	if (!empty($result)) {
		foreach ($result as $sectionId => $section) {
            if (empty($section)) {
                unset($result[$sectionId]);
            }
		}
	}

    /** получение контента */
	if ($getContent && !empty($result)) {
        $contents = connect()->table('sections')->select($fields)->in('sectionId', array_keys($result))->getAll();
        foreach ($contents as $item) {
            $result[$item->sectionId]['content'] = $item->content;
        }
	}

	/** получение картинки */
	if ($image === true && !empty($result)) {
	    $result = prepareSections($result, $imageType);
	}

//    print_r($result);
	$smarty->assign($assign, $result);
	

	return null;
}
