<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

function smarty_function_fetch_project($params, &$smarty){
	global $gmNow;

	$assign        = fetch_getParam('assign', $params, 'project');
	$fields        = fetch_getParam('fields', $params, 'sectionId, publishedOn, title, alias, url, summary, isFeatured, counter, addedBy, modifiedBy');
	$status        = fetch_getParam('status', $params, 'V');
	$isFeatured    = fetch_getParam('isFeatured', $params, NULL);
	$hasImage      = fetch_getParam('hasImage', $params, NULL);
	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);
	$section       = fetch_getParam('section', $params);
    $projectId     = (int) fetch_getParam('projectId', $params);
	$skip          = fetch_getParam('skip', $params, NULL);
	$noSubsections = (boolean) fetch_getParam('noSubsections', $params, false);
    $typeContent   = fetch_getParam('typeContent', $params);

	/* conditions */
    connect()->where('publishedOn','<=', $gmNow);
	if(!empty($status)) connect()->where('status',$status);
	if(!is_null($isFeatured)) connect()->where('isFeatured',(boolean) $isFeatured ? 1 : 0);
	if(is_null($orderBy)) connect()->orderBy(is_null($query) ? 'publishedOn DESC' : '');
	if ($projectId > 0) connect()->where('projectId',$projectId);

	/* query conditions */
	fetch_projects_addQueryConditions($query, $match, $fields, $orderBy);

	/* add section conditions */
	fetch_projects_addSectionConditions($section, $noSubsections);

	/* skipping articles */
	fetch_projects_addSkipConditions($skip);

	/* checking article fields */
	fetch_projects_filterFields($fields);

	/* calculate article popularity article fields */
	fetch_projects_calculatePopularity($orderBy);

	if(!is_null($query) && empty($query)){
        $project = array();
	} else {
        if ($project = connect('projects')->select($fields)->get('array')) {
            $project = prepareProject($project);
        }
	}
//	print_r($article);
	$smarty->assign($assign, $project);


	return null;
}
?>