<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\Uploads\ImageSizes;
use Mnv\Core\Utilities\Cookie\Session;

function smarty_function_fetch_order($params, &$smarty) {
	
	$assign        = fetch_getParam('assign', $params, 'order');
    $status        = fetch_getParam('status', $params, 'V');
    $userId        = fetch_getParam('user', $params, );
    $orderId        = fetch_getParam('order', $params, );


	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_order: "assign" must not be empty');
		return;
	}
    $data = [];
	if (!empty($userId) && !empty($orderId)) {
	    $order_info = connect('shop_orders')->select('*')->where('order_id', $orderId)->get('array');
	    if (!empty($order_info)) {
	        $data['order_id']           = $orderId;
//	        $data['order_id']           = $order_info['order_id'];
	        $data['createdBy']          = $order_info['createdBy'];
	        $data['payment_choice']     = $order_info['payment_choice'];
	        $data['payment_method']     = $order_info['payment_method'];
	        $data['shipping_zone']      = $order_info['shipping_zone'];
	        $data['shipping_method']    = $order_info['shipping_method'];
	        $data['shipping_coordinates']  = $order_info['shipping_coordinates'];
	        $data['status']             = $order_info['status'];
	        $data['state']              = $order_info['state'];
	        $data['shipping_amount']    = $order_info['shipping_amount'];
	        $data['products_amount']    = $order_info['products_amount'];
	        $data['amount']             = $order_info['amount'];
	        $data['message']            = $order_info['message'];
            $data['order_status_name']  = connect('shop_order_status')->select('name')->where('order_status_id', $order_info['order_status_id'])->getValue();
//
            $products = connect('shop_order_product')->select('*')->where('order_id', $orderId)->getAll('array');
            foreach ($products as $product) {
                $data['products'][] = array(
                    'product_id' => $product['product_id'],
                    'name'       => $product['name'],
                    'sku'        => $product['sku'],
                    'ikpu'       => $product['ikpu'],
                    'brand'      => connect('brands')->select('name')->where('fileName', $product['brand'])->getValue(),
                    'option'     => connect('shop_order_option')->select('*')->where('order_id', $orderId)->where('order_product_id',$product['order_product_id'])->getAll('array'),
                    'quantity'   => $product['quantity'],
                    'price'      => $product['price'],
                    'total'      => $product['total'],
                );
            }

            $data['totals'] = connect('shop_order_total')->select('*')->where('order_id', $orderId)->orderBy('sort_order')->getAll('array');

        }


//        print_r($data);
        $smarty->assign($assign, $data);

    }

	return null;

}

?>