<?php

namespace Mnv\Modules\Payment\Paypal\Form;

use Mnv\Modules\Payment\PaymentMethodService;
use Mnv\Modules\Payment\PaymentMethodInterface;

/**
 * Class PayPal
 */
class PayPal implements PaymentMethodInterface
{

    //const SUCCESS  = SITE_URL.'/payment-success.htm';
    //const FAILED   = SITE_URL.'/failed.htm';
    const NOTIFY   = GLOBAL_URL.'/request/callback.php';

    private $paypal_url;
    private $MERCHANT;
    public $CURRENCY;

    private $returnSuccessUrl;
    private $returnFailedUrl;

    public function __construct()
    {
        $payment = new PaymentMethodService('paypal');
        $this->MERCHANT = $payment->payment_method->settings->merchant;
        $this->CURRENCY = $payment->payment_method->settings->currency;

        //$this->endpoint = '/nvp';
        if ($payment->payment_method->settings->mode == 'live') {
            //$this->host = "api-3t.paypal.com";
            $this->paypal_url = 'https://www.paypal.com/cgi-bin/webscr';
        } else {
            //sandbox
            //$this->host = "api-3t.sandbox.paypal.com";
            $this->paypal_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
        }
    }

    public function form(int $orderId, float $amount, int $userId = null, string $fullName = null, string $userPhone = null, string $userEmail = null, array $note = null, string $lang = null, bool $auto = true): ?string
    {
        if (!$orderId) return null;

        $button = '<button type="submit"></button>';
        if ($auto) {
            $auto   = '<script type="text/javascript">paypal.submit()</script>';
            $button = '';
        }
       
        if (isset($lang) && !empty($lang)) {
            $this->returnSuccessUrl = SITE_URL . '/' . $lang . '/payment-success.htm';
            $this->returnFailedUrl  =  SITE_URL . '/' . $lang . '/failed.htm';
            
        } else {
            $this->returnSuccessUrl  = SITE_URL.'/payment-success.htm';
            $this->returnFailedUrl   = SITE_URL.'/failed.htm';
        }


        $fields = $this->fields($orderId, $amount, $userId, $fullName, $userPhone, $userEmail, $note, $lang);

        return <<<HTML
<form action="$this->paypal_url" method="post" name="paypal" target="_blank">
{$fields}
{$button}
</form>
{$auto}
HTML;

    }

    public function fields(int $orderId, float $amount, int $userId = null, string $fullName = null, string $userPhone = null, string $userEmail = null, array $note = null, string $lang = null): string
    {
        $fields = array(
            'cmd'           => '_xclick',
            'charset'       => 'utf-8',
            'business'      => $this->MERCHANT,
            'currency_code' => $this->CURRENCY,
            'invoice'       => $orderId,
            'item_name'     => $fullName,
            'amount'        => $amount,
            'return'        => $this->returnSuccessUrl,
            'cancel_return' => $this->returnFailedUrl,
            'notify_url'    => self::NOTIFY,
            'rm'            => 'POST'
        );

        $html = '';

        foreach ($fields as $field => $val) {
            $html .= '<input type="hidden" name="' . $field . '" value="' . $val . '" />' . PHP_EOL;
        }

        return $html;
    }


}


//<form action="https://www.sandbox.paypal.com/cgi-bin/webscr" method="post">
//    <div>
//        <label for="amount">Amount for transfer</label>
//        <input id="amount" type="text" />
//    </div>
//    <input type="hidden" name="cmd" value="_donations" />
//    <input type="hidden" name="charset" value="utf-8" />
//    <input type="hidden" name="bussiness" value="business@paypal.acc" />
//    <input type="hidden" name="item_name" value="Item short name" />
//    <input type="hidden" name="currency_code" value="USD" />
//    <input type="hidden" name="undefined_quantity" value="1" />
//    <input type="hidden" name="return" value="https://site.com/" />
//    <input type="hidden" name="cancel_return" value="https://site.com/" />
//    <input type="hidden" name="notify_url" value="https://site.com/paypal/result" />
//    <input type="hidden" name="custom" value="userId:1|orderId:25" />
//    <input type="hidden" name="button_subtype" value="services" />
//    <input type="hidden" name="no_note" value="1" />
//    <input type="hidden" name="no_shipping" value="1" />
//    <input type="hidden" name="rm" value="" />
//    <div>
//        <input type="submit" value="Transfer" />
//    </div>
//</form>