<?php

namespace Mnv\Models\Users;

use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;

/**
 * Class SubscribersUser
 * @package Mnv\Models\Users
 */
class SubscribersUser extends AbstractUser
{
    /**
     * Таблица, связанная с моделью.
     *
     * @var string
     */
    protected string $table = 'subscribe';

    protected function sorting()
    {
        if (!empty($this->filter['query'])) {
            connect()->grouped(function($q) {
                $q->like('email', "%" . $this->filter['query'] . "%")->orLike('phone',"%" . $this->filter['query'] . "%");
            });
        }
    }

    /**
     * Получение всех пользователей
     *
     * @param string|null $orderBy
     * @param int $limit
     * @param int $page
     */
    public function all(?string $orderBy, int $limit, int $page)
    {
//        /** Фильтровать пользователей */
//        $this->sorting();

        return connect($this->table)->select('*')->pagination($limit, $page)->orderBy($orderBy)->getAll('array');
    }

    /**
     * получение кол-во пользователей
     */
    public function total() : void
    {
        /** Фильтровать пользователей */
//        $this->sorting();
        $this->total = (int)connect($this->table)->count('*', 'count')->getValue();
    }


    /**
     * Получить пользователя
     */
    public function get(?string $userType = null): void
    {
        $this->user = connect($this->table)->where($this->primaryKey, $this->userId)->get('array');
    }

    public function edit(?string $userType)
    {
        if (!empty($this->userId)) {
            $this->get($userType);
            if ($this->user == null) {
                throw new NoUserException();
            }
        }
    }

    /**
     * Проверить на существование
     * @param string $field по какому полю проверять (`email` или `phone`)
     * @param string $param приходящий параметр для сравнения
     * @return bool
     */
    public function existSubscribe(string $field, string $param): bool
    {
        if (connect($this->table)->count('*')->where($field, $param)->getValue()) return true;

        return false;
    }

    /**
     * Проверка на совпадение email
     * @param string $email
     * @return string|null
     */
    public function checkEmailUser(string $email): ?string
    {
        if (!empty($this->userId)) connect()->where('userId','<>', $this->userId);
        if ($email = connect($this->table)->select('email')->where('email', $email)->getValue()) {
            return $email;
        }

        return null;
    }

    public function prepare(array $data): bool
    {
        if (empty($this->userId)) {
            $data['registered'] = gmdate('Y-m-d H:i:s');
            return $this->insert($data);
        } else {
            return $this->update($data);
        }
    }


    /**
     * Удаление пользователя
     */
    public function deleteSubscriber(): bool
    {
        if (!empty($this->userId)) {
            connect($this->table)->where($this->primaryKey,  $this->userId)->delete();
            return true;
        }
        return false;
    }

    /**
     * Обновление статуса
     */
    public function approve() { }

    public function remove(?string $userType)
    {
        // TODO: Implement remove() method.
    }
}