<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class Products
 * @package Mnv\Models\Contents
 */
class Blocks extends Model
{

    /** @var string */
    protected string $table = 'blocks';

    /** @var string  */
    protected string $table_image = 'block_images';

    /** @var string  */
    protected string $primaryKey = 'blockId';

    /** @var string  */
    protected string $orderBy = 'orderBy ASC';

    /** @var array|mixed  */
    public $blockIds = [];

    public $imageSizes = array(
        '' => 'Выберите размер изображения',
        'F' => '50%',
        'B' => '100%'
    );

    public $backgrounds = array(
        '' => 'Выберите фон',
        'L' => 'Светлый',
        'D' => 'Темный'
    );

    public $positions = array(
        'L' => 'Слева картинка',
        'R' => 'Справа картинка',
        'C' => 'По центру картинка',
        'S' => 'Слайдер'
    );

    public $text_positions = array(
        '' => 'Выберите расположение текста',
        'L' => 'Слева',
        'R' => 'Справа',
        'C' => 'По центру',
    );

    public function __construct(Request $request)
    {
        $this->id       = $request->get('id');
        $this->data     = $request->get('block', '');
        $this->blockIds = $request->get('ids', '');

        $this->sortBy       = $request->get('sortBy', '');
        $this->sortOrder    = $request->get('sortOrder', '');
    }

    /** фильтрация / сортировка */
    private function sorting(): void
    {
        global $SECTIONS;

        if (!empty($this->filter['query'])) {
            connect()->grouped(function($q) {
                $q->like('title', "%" . $this->filter['query'] . "%")->orLike('content', "%" . $this->filter['query']. "%");
            });
        }
        if (!empty($this->filter['status'])) connect()->where('status', $this->filter['status']);

        if (!empty($this->filter['section']) && !empty($SECTIONS[$this->filter['section']])) {
            $sectionIds = array($this->filter['section']);
            if (!empty($SECTIONS[$this->filter['section']]['allChildren'])) {
                $sectionIds = array_merge($sectionIds, $SECTIONS[$this->filter['section']]['allChildren']);
            }

            connect()->in('sectionId', $sectionIds);
        }
    }

    /** Получение всех */
    public function all($limit, $page)
    {
        /** фильтрация / сортировка */
        $this->sorting();
        return parent::all($limit, $page);

    }

    /** Получение кол-во */
    public function total(): void
    {
        /** фильтрация / сортировка */
        $this->sorting();
        parent::total();
    }

    public function prepare(array $data, int $managerId): bool
    {

        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = $this->getMaxValue('orderBy') + 1;
            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }


}