<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class BannerGroups
 * @package Mnv\Models
 */
class BannerGroups extends Model
{
    /** @var string */
    protected string $table = 'banners_group';
    /** @var string  */
    protected string $primaryKey = 'groupId';

    /** @var string  */
    protected string $orderBy = 'orderBy ASC';

    public $groupIds;
    public $sectionIds = [];

    public function __construct(Request $request)
    {
        $this->id           = $request->get('id');                 // getRequestVar('id', ''),
        $this->data         = $request->get('group', '');   // getRequestVar('group', '',  true)
        $this->groupIds     = $request->get('ids', '');     // getRequestVar('ids', '', true);
        $this->sectionIds   = $request->get('sectionIds', '');
    }

    /**
     * Все группы со статусом `visible` для select
     * @return array
     */
    public static function getGroups(): array
    {
        $groupSelects = array('' => lang('general:select'));
        if ($groups = connect()->table('banners_group')->where('status', 'V')->orderBy('orderBy')->indexKey('groupId')->getAllIndexes()) {
            foreach ($groups as $groupId => $group) {
                $groupSelects[$groupId] = $group->name;
            }
        }
        return $groupSelects;
    }

    public function getPageName($sectionId)
    {
        return connect()->table('sections')->select('name')->where('sectionId', $sectionId)->getValue();
    }


    public static function getGroupName($groupId)
    {
        return connect()->table('banners_group')->select('name')->where('groupId', $groupId)->getValue();
    }

    public function prepare(array $data, int $managerId): bool
    {
        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = $this->getMaxValue('orderBy') + 1;

            if ($this->id = $this->insert($data)) {
                $this->setTracking();
                return true;
            }
        }
        else {
            $this->update($data);
            $this->setTracking();

            return true;
        }

        return false;
    }

    private function setTracking(): void
    {
        $sectionIds = connect('banner_tracking')->where('groupId', $this->id)->indexKey('sectionId')->valueKey('sectionId')->getAllIndexes('array');
        if (!empty($sectionIds)) {
            connect('banner_tracking')->where('groupId', $this->id)->in('sectionId', $sectionIds)->delete();
        }

        foreach ($this->sectionIds as $sectionId) {
            connect('banner_tracking')->replace(['groupId' => $this->id, 'sectionId' => $sectionId]);
        }
    }

    public function checkFileName(?string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }


    public function getTracking($groupId)
    {
        return connect('banner_tracking')->where('groupId', $groupId)->indexKey('sectionId')->valueKey('sectionId')->getAllIndexes('array');
    }
}