<?php


namespace Mnv\Core\Uploads;


use Mnv\Core\Singleton\SingletonTrait;

class ImageCollection
{

    use SingletonTrait;

    /** @var array|string[]  */
    private static array $sizes = array('large', 'medium', 'small');

    /**
     * @param $image
     * @param $file
     * @return array
     */
    public static function get($image, $file): ?array
    {
        $collection = $image ?? [];
        $fileFormat = self::fileExtension($file['fileName']);


        if (file_exists(GLOBAL_ROOT . $file['path'] . $file['fileName'])) {
            $collection['original'] = GLOBAL_URL . $file['path'] . $file['fileName'];
        }
        /** получим все размеры */
        foreach (self::$sizes as $size) {
            if (file_exists(GLOBAL_ROOT . $file['path'] . $size . '/' . $file['fileName'])) {
                $collection[$size] = GLOBAL_URL .$file['path'] . $size . '/' . $file['fileName'];
            }
        }

        /** если это `svg` получим все размеры из оригинальной */
        if ($fileFormat == 'svg') {
            foreach (self::$sizes as $size) {
                if (file_exists(GLOBAL_ROOT . $file['path'] . $file['fileName'])) {
                    $collection[$size] = GLOBAL_URL . $file['path'] . $file['fileName'];
                }
            }
        }

        unset($collection['fileId']);
        unset($collection['type']);

        return $collection;
    }


    /**
     * получить расширение файла
     *
     * @param $name
     * @return false|string
     */
    public static function fileExtension($name)
    {
        $n = strrpos($name, '.');
        return ($n === false) ? '' : substr($name, $n+1);
    }
}