<?php


namespace Mnv\Core\Filesystem;


use Mnv\Core\Uploads\ImageGenerator;
use Mnv\Core\Uploads\ImagineGenerator;

/**
 * Class FilesystemFactory
 * @package Mnv\Core\Filesystem
 */
class FilesystemFactory
{

    /**
     * @param $realPath
     * @param $path
     * @param $managerId
     * @return ImagineGenerator
     */
    public static function imagineGenerator($realPath, $path, $managerId) : ImagineGenerator
    {
        return new ImagineGenerator($realPath, $path, $managerId);
    }

    /**
     * @param $realPath
     * @param $path
     * @param $managerId
     * @return ImageGenerator
     */
    public static function imageGenerator($realPath, $path, $managerId) : ImageGenerator
    {
        return new ImageGenerator($realPath, $path, $managerId);
    }
}