
{if isset($action) && ($action eq 'add' || $action eq 'edit')}

	<form method="post" enctype="multipart/form-data">
		<!-- Page header -->
        {include file="components/group-buttons.tpl" url="{$adminUrl}/typecontent"}

        {capture name="breadcrumb"}
			<a href="{$adminUrl}/typecontent" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
{*			<span class="breadcrumb-item active">{general:add}</span>*}
        {/capture}

        {capture name="showBy"}{/capture}

        {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
		<!-- /page header -->

		<div class="content">

			<div class="row">
				<div class="col-md-12">
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">{general:card:general}</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body">
								<div class="row">
									<div class="col-md-4">
										<div class="form-group mb-3">
											<label class="form-label is-visible {if isset($errors.name)}text-danger{/if}">{general:title}</label>
											<input type="text" class="form-control" id="name" autocomplete="off" name="type[name]" value="{if isset($type.name)}{$type.name}{/if}">
										</div>
									</div>
									<div class="col-md-4">
										<div class="form-group mb-3">
											<label class="form-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">Название свойства на анг</label>
											<input type="text" class="form-control" id="fileName" name="type[fileName]" value="{if isset($type.fileName)}{$type.fileName}{/if}">
										</div>
									</div>

									{* field status *}
									{include file="components/fields/select.tpl" col="col-md-4" id="status" title="{general:status}" field="type[status]" array=$statuses selected=$type.status|default:'visible' class="form-group mb-3"}
									{* /field status *}

								</div>
							</div>
						</div>
					</div>

					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">Поля</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body flex-column flex-md-row m-0  p-0">
								<table class="table table-xs table-togglable table-striped table-hover" id="fields">
								<thead>
								<tr>
									<th>Название поля</th>
									<th>Код поля</th>
									<th data-toggle="true">Тип поля</th>
									<th data-hide="phone" class="text-center">{general:status}</th>
									<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
								</tr>
								</thead>
                                {if !empty($typeContentFields)}
									<tbody class="selectable-demo-list">
                                    {foreach from=$typeContentFields item=typeContentField}
										<tr id="social-{$typeContentField.fieldId}" data-id="{$typeContentField.fieldId}" class="{if $typeContentField.status eq 'hidden'}table-warning{/if}">
											<td class="text-start"> {$typeContentField.name nofilter}</td>
											<td class="text-start"> {$typeContentField.fileName nofilter}</td>
											<td class="text-start"> {$typeContentField.typeFieldName nofilter}</td>
											<td class="text-center" id="status-{$typeContentField.fieldId}">{$typeContentField.statusName nofilter}</td>
											<td class="text-center">
												<div class="d-inline-flex">
													<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/field?action=edit{if isset($type.typeId)}&typeId={$type.typeId}{/if}&id={$typeContentField.fieldId}"><i class="ph-note-pencil me-2"></i></a>

													<div class="list-icons-item dropdown">
														<a href="javascript:void('');" class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

														<div class="dropdown-menu dropdown-menu-right">
															<a class="dropdown-item" href="{$adminUrl}/field?action=edit{if isset($type.typeId)}&typeId={$type.typeId}{/if}&id={$typeContentField.fieldId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
															<button class="dropdown-item ajax_action {if $typeContentField.status eq 'visible'}active_class{/if}" data-module="field" data-action="status" data-id="{$typeContentField.fieldId}"><i class="{if $typeContentField.status eq 'visible'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
															<div class="dropdown-divider"></div>
															<button class="dropdown-item text-danger" onclick="remove({$typeContentField.fieldId}, '{$typeContentField.name}', 'field');"><i class="ph-trash me-2"></i> {general:delete}</button>
														</div>
													</div>
												</div>
											</td>
										</tr>
                                    {/foreach}

									</tbody>
                                {else}
									<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                                {/if}
							</table>
							</div>
							<div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
								<a class="btn btn-sm btn-primary" href="{$adminUrl}/field?action=add{if isset($type.typeId)}&typeId={$type.typeId}{/if}"><i class="ph-plus me-2"></i>{general:add} поле</a>
							</div>
						</div>
					</div>

                    {* summary / content *}
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">{general:card:description}</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body flex-column flex-md-row m-0  p-0">
								<textarea name="type[content]" class="description">{if isset($type.content)}{$type.content}{/if}</textarea>
							</div>
						</div>
					</div>



				</div>

				<div class="col-md-12 main main_buttons text-center">
                    {$smarty.capture.buttons nofilter}
				</div>

			</div>
		</div>
	</form>

    {* Подключаем Tiny MCE *}
    {include file='tinymce_init.tpl'}

	<script>

        function notFound() {
            new Noty({ text: '{articles:errors:6}', layout: 'topRight', type: 'error', timeout: 1500 }).show();
        }
        function deleteMessage(){
            new Noty({ text: '{articles:messages:2}', type: 'success', timeout: 1500 }).show();
        }



        $(document).ready(function () {
            {if isset($messages.saved)} new Noty({ text: 'Свойство "{if isset($feature.name)}{$feature.name}{/if}" сохранено', type: 'success', timeout: 1500 }).show(); {/if}

            {if isset($errors.name)} new Noty({ text: 'Введите название свойства', type: 'error', timeout: 2500 }).show();{/if}
            {if isset($errors.not_saved)} new Noty({ text: 'Свойство "{if isset($feature.name)}{$feature.name}{/if}" не сохранено', type: 'error', timeout: 2500 }).show(); {/if}
            {if isset($errors.fileName)} new Noty({ text: 'Введите название свойства на анг. языке', type: 'error', timeout: 2500 }).show(); {/if}
            {if isset($errors.fileNameExists)} new Noty({ text: 'Введите название свойства на анг. языке', type: 'error', timeout: 2500 }).show(); {/if}
            {if isset($errors.fileNameProhibited)} new Noty({ text: 'Такое название нельзя использовать', type: 'error', timeout: 2500 }).show(); {/if}
            {if isset($errors.fileNameCharacters)} new Noty({ text: 'Имя файла может содержать только следующие символы: a-z', type: 'error', timeout: 2500 }).show(); {/if}

        });

	</script>


{else}

<!-- Inner content -->
<div class="content-inner">
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/field?action=add{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
		<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/typecontent?action=add{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/typecontent" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/typecontent"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">
	    <div class="row">
	        <div class="col-md-12">
	            <div class="card border shadow-sm">
		            <div class="">
			            <table class="table table-xs table-togglable table-striped table-hover" id="fields">
		                    <thead>
		                        <tr>
			                        <th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
		                            <th data-toggle="true">Тип контента</th>
		                            <th data-hide="phone" class="text-center">{general:status}</th>
		                            <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
		                        </tr>
		                    </thead>
		                    {if !empty($types)}
			                    <tbody class="selectable-demo-list">
			                        {foreach item=type from=$types name=types}
			                        <tr id="social-{$type.typeId}" data-id="{$type.typeId}" class="{if $type.status eq 'hidden'}table-warning{/if}">
				                        <td class="text-start text-nowrap">{$type.typeId}</td>
			                            <td class="text-start" width="100%"> {$type.name nofilter}</td>
			                            <td class="text-center" id="status-{$type.typeId}">{$type.statusName nofilter}</td>
			                            <td class="text-center">
			                                <div class="d-inline-flex">
				                                <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/typecontent?action=edit&id={$type.typeId}"><i class="ph-note-pencil me-2"></i></a>
			                                    <div class="dropdown">
				                                    <a href="javascript:void('');" class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

			                                        <div class="dropdown-menu dropdown-menu-end">
			                                            <a class="dropdown-item" href="{$adminUrl}/typecontent?action=edit&id={$type.typeId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
				                                        <button class="dropdown-item ajax_action {if $type.status eq 'visible'}active_class{/if}" data-module="typecontent" data-action="status" data-id="{$type.typeId}"><i class="{if $type.status eq 'visible'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
			                                            <div class="dropdown-divider"></div>
			                                            <button class="dropdown-item text-danger" onclick="remove({$type.typeId}, '{$type.name}', 'typecontent');"><i class="ph-trash me-2"></i> {general:delete}</button>
			                                        </div>
			                                    </div>
			                                </div>
			                            </td>
			                        </tr>
			                        {/foreach}

			                    </tbody>
		                    {else}
		                        <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
		                    {/if}
	                    </table>
		            </div>

	                {include file="module/pagination.tpl" url="{$adminUrl}/typecontent" params="{$buildQueryString}"}

	            </div>
	        </div>
	    </div>
	</div>

	<script>
	    $(document).ready(function() {
	        {if isset($errors.errorName)} new Noty({ text: '{socials:errors:0}', type: 'error', timeout: 1500 }).show(); {/if}
	        {if isset($errors.fileNameEmpty)} new Noty({ text: '{socials:errors:1}', type: 'error', timeout: 1500 }).show(); {/if}
	        {if isset($errors.fileNameError)} new Noty({ text: '{socials:errors:2}', type: 'error', timeout: 1500 }).show(); {/if}
	        {if isset($errors.not_saved)} new Noty({ text: '{socials:errors:3}', type: 'error', timeout: 1500 }).show(); {/if}
	        {if isset($messages.saved)} new Noty({ text: '{socials:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
	    });
	    function deleteMessage() {
	        new Noty({ text: '{socials:messages:1}', type: 'success', timeout: 1500 }).show();
	    }
	    function reorderMessage() {
	        new Noty({ text: '{socials:messages:3}', type: 'success', timeout: 1500 }).show();
	    }

	</script>
</div>
{/if}





