<!-- Page header -->
{capture name="buttons"}
    {if !empty($sections)}
		<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/feature?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
    {/if}
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/features" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/features"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<div class="content">
    <div class="row">
    	<div class="col-md-12">
		    <div class="card">
                {include file="components/selectors.tpl" filter=true url="{$adminUrl}/features" filterDate=false}
		    </div>
{*		    <div class="card">*}
{*			    <div class="alert bg-danger text-white alert-dismissible m-0">*}
{*				    <span class="font-weight-semibold">Удалять нельзя!</span>*}
{*			    </div>*}
{*		    </div>*}
            <div class="card">
	            <div class="">
		            <table class="table table-togglable table-xs table-striped table-hover feature-archive" id="features">
			            <thead>
				            <tr>
					            <th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
					            <th data-toggle="true">{general:table:name}</th>
					            <th data-toggle="true">{general:table:section}</th>
					            <th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
				            </tr>
			            </thead>
	                    {if $features}
		                    <tbody class="sortable">
		                    {foreach from=$features item=feature name=features}
					            <tr id="feature-{$feature.id}" data-id="{$feature.id}" class="{if $feature.status eq 'H'}table-warning{/if}">
						            <td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
						            <td class="text-start text-nowrap">{$feature.name nofilter}</td>
						            <td class="text-start text-nowrap">{assign var=a value=1}
							            {foreach from=$feature.sections item=section}
								            <span class="badge bg-warning">{$section}</span>
                                        {if $a eq 5}
                                        {assign var=a value=0}
	                                        <br>
					                    {/if}
					                    {assign var=a value=$a+1}
							            {/foreach}
						            </td>
						            <td class="text-center">
							            <div class="d-inline-flex">
								            <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/feature?action=edit&id={$feature.id}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
								            <div class="dropdown">
									            <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
									            <div class="dropdown-menu dropdown-menu-end">
										            <a class="dropdown-item" href="{$adminUrl}/feature?action=edit&id={$feature.id}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
										            <button class="dropdown-item ajax_action" id="article-status-{$feature.id}" data-module="features" data-action="status" data-id="{$feature.id}"><i class="{if $feature.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
										            <div class="dropdown-divider"></div>
										            <button class="dropdown-item text-danger" onclick="newRemove('{$feature.id}', '{$feature.name|escape nofilter}', 'features');"><i class="ph-trash me-2"></i> {general:delete}</button>
									            </div>
								            </div>
							            </div>
						            </td>
					            </tr>
	                        {/foreach}

				            </tbody>

	                        {else}
				            <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
	                        {/if}
		            </table>
	            </div>
                {include file="module/pagination.tpl" url="{$adminUrl}/features" params="{$buildQueryString}"}
            </div>
    	</div>
    </div>
</div>

	<script>


    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.not_saved)}   new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}

    });

    function successImageMessage(){
        new Noty({ text: '{sections:messages:10}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }

    function deleteError(){
        new Noty({ text: 'ошибка при удаление контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id) {
        new Noty({ text: '{articles:messages:2}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'feature');
    }

    function notFound(){
        new Noty({ text: 'контент не найден или пустой ID', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function approveError(){
        new Noty({ text: 'ошибка при одобрение контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }
    function statusError() {
        new Noty({ text: 'ошибка при изменение статуса контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/features?action=reorder", { ids : ids }, function( data ) {
            $('.sortable_footer_navbar').removeClass('show');
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })


</script>



