<form method="post" id="order">

	<!-- Page header -->
    {capture name="buttons"}
	    <a class="btn btn-sm btn-primary legitRipple" href="{$adminUrl}/orders">Вернуться к списку</a>
    {/capture}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/orders" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <div class="content">
    	<div class="card">
		    <div class="card-header d-flex flex-wrap">
			    <h6 class="mb-0">Заказ #{$order.order_id|default:''}</h6>
			    <div class="d-inline-flex ms-auto">
				    <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			    </div>
		    </div>
		    <div class="collapse show">
			    <div class="card-body">
				    <div class="d-lg-flex flex-lg-wrap">
					    <div class="mb-4 mb-lg-2">
						    <h4 class="text-primary mb-2 mt-lg-2">Продавец:</h4>
						    <ul class="list list-unstyled mb-0">
							    <li>{$config.company_name}</li>
							    <li>Адрес: {$config.address}</li>
							    <li>Телефон: {$config.phone}</li>
							    <li>Email: {$config.email}</li>
						    </ul>
					    </div>

					    <div class="mb-2 ms-auto">
						    <div class="d-flex flex-wrap wmin-lg-400">
							    <ul class="list list-unstyled mb-0">
								    <li><h5 class="my-2 me-2">Общая сумма:</h5></li>
								    <li><span class="fw-semibold">Ф.И.О:</span></li>
								    <li><span class="fw-semibold">Телефон:</span></li>
								    <li><span class="fw-semibold">Дата:</span></li>
								    <li><span class="fw-semibold">Адрес:</span></li>
							    </ul>

							    <ul class="list list-unstyled text-end mb-0 ms-auto">
	                                {if isset($order.order_id)}
									    <li><h5 class="fw-semibold my-2 me-2"> {$order.amount|number_format:0:".":" "} сум</h5></li>
									    <li><span class="fw-semibold">{$order.fullName}</span></li>
		                                <li><span class="fw-semibold">{if !empty($order.phone)}{$order.phone}{else} не указан{/if}</span></li>
									    <li><span class="fw-semibold">{$order.createdBy|date_format:$config.date_format_custom}</span></li>
									    <li><span class="fw-semibold">{$order.address}</span></li>
	                                {/if}
							    </ul>
						    </div>
					    </div>
				    </div>
			    </div>
			    {if !empty($order.products)}
	            <div class="table-responsive">

	                <table class="table table-xs table-bordered">
	                    <thead>
	                        <tr>
				                <th class="text-start">Наименование товара</th>
				                <th class="text-start">Артикул</th>
				                <th class="text-center">Кол-во</th>
				                <th class="text-end">Цена за товар</th>
				                <th class="text-end">Итого за товар</th>
	                        </tr>
	                    </thead>
	                    <tbody>

	                        {foreach from=$order.products item=product}
				            <tr>
					            <td class="text-start">
						            <a href="product?action=edit&id={$product.product_id}" target="_blank">{$product.name}</a><br>
						            <ul class="list list-unstyled mb-0 text-muted fs-sm">
                                        {foreach from=$product.option item=option key=key}
								            <li>- {$option.name}: {$option.value}</li>
                                        {/foreach}
						            </ul>
					            </td>
					            <td class="text-start">{$product.sku}</td>
					            <td class="text-end">{$product.quantity}</span></td>
					            <td class="text-end">{$product.price|number_format:0:".":" "} сум</td>
					            <td class="text-end">{$product.total|number_format:0:".":" "} сум</td>
				            </tr>
	                    {/foreach}

	                    </tbody>
	                </table>
	            </div>
				{/if}
	            <div class="card-body border-top">
	                <div class="d-lg-flex flex-lg-wrap">
	                    <div class="pt-2 mb-3">
	                        <h6>Комментарий к заказу</h6>
	                        <p>{$order.message|wordwrap:50:"<br />\n"|default:'' nofilter}</p>
	                    </div>

	                    {if isset($order.order_id)}
	                    <div class="pt-2 mb-3 wmin-lg-400 ms-auto">
	                        <h6 class="mb-3">Сумма к оплате</h6>
	                        <div class="table-responsive">
	                            <table class="table">
	                                <tbody>
	                                {foreach from=$order.totals item=total}
									    <tr>
										    <th class="text-end">{$total.title}:</th>
										    <td class="text-end"><span class="fw-semibold">{$total.value|number_format:0:".":" "}</span> сум</td>
									    </tr>
	                                {/foreach}
	                                </tbody>
	                            </table>
	                        </div>


	                    </div>
					    {/if}
	                </div>
	            </div>
    
{*    		<div class="card-footer">*}
    {* 			<span class="text-muted">Thank you for using Limitless. This invoice can be paid via PayPal, Bank transfer, Skrill or Payoneer. Payment is due within 30 days from the date of delivery. Late payment is possible, but with with a fee of 10% per month. Company registered in England and Wales #6893003, registered office: 3 Goodman Street, London E1 8BF, United Kingdom. Phone number: 888-555-2311</span> *}
{*    		</div>*}
		    </div>
    	</div>
    </div>


</form>

<script>
        $(document).ready(function () {
          {if isset($messages.saved)} new Noty({ text: '{orders:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
        });
        
        function deleteMessage(){
            new Noty({ text: '{orders:messages:1}', type: 'success', timeout: 1500 }).show();
        }


</script>