<!-- Page header -->
{capture name="buttons"}
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/feedbacks" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/feedbacks"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<!-- Content area -->
<div class="content">

	<div class="row">
		<div class="col-md-12">
			<div class="card">
                {include file="components/selectors.tpl" filter=true url="{$adminUrl}/feedbacks" filterDate=true}
			</div>

			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-xs table-togglable table-striped table-hover mails-archive" id="feedbacks">
						<thead>
						<tr>
							<th class="text-center" data-width="30">{users:table:id}</th>
							<th class="text-start" data-width="30">{users:table:date}</th>
							<th class="">Ф.И.О.</th>
							<th>{users:table:email}</th>
							<th>{users:table:phone}</th>
							<th class="">Сообщение</th>
							<th class="text-center">{general:table:status}</th>
							<th class="text-center text-muted" data-width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if isset($feedbacks)}
							<tbody>
                            {foreach item=feedback from=$feedbacks name=feedbacks}
								<tr id="feedback-{$feedback.id}" data-id="{$feedback.id}" class="{if $feedback.status eq 'hidden'}table-warning{/if}">
									<td class="text-nowrap">{$feedback.id}</td>
									<td class="text-nowrap"><b>{$feedback.created}</b></td>
									<td class="text-left">{$feedback.fullName}</td>
									<td class="text-left">{$feedback.email}</td>
									<td class="text-left">{$feedback.phone}</td>
									<td class="text-left"><span class="fw-semibold">{$feedback.subject nofilter}</span><br><br>{$feedback.message nofilter}</td>
									<td class="text-left">
										{html_options options=$statuses name="feedback[status]" id="status_{$feedback.id}" selected=$feedback.status|default:"" data-id="{$feedback.id}" class="form-control select change_status"}
									</td>
									<td class="text-center">
										<div class="d-inline-flex">
											<a class="text-primary btn btn-link p-1" data-bs-popup="tooltip" title="Читать" data-bs-placement="auto" href="{$adminUrl}/feedback?action=read&id={$feedback.id}"><i class="ph-note-pencil"></i></a>
											<button class="text-danger btn btn-link p-1" data-bs-popup="tooltip" title="{general:delete}" data-bs-placement="auto" onclick="newRemove('{$feedback.id}', '{$feedback.fullName}', 'feedbacks');"><i class="ph-trash"></i></button>
										</div>
									</td>
								</tr>
                            {/foreach}

							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/feedbacks" params="{$buildQueryString}"}
			</div>
		</div>

	</div>
</div>

<script>

    function deleteSuccess(id) {
        new Noty({  text: '{users:messages:1}', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'feedback');
    }
    function deleteError(){
        new Noty({ text: '{users:errors:17}', type: 'error' }).show();
    }

    $(document).on('change', '.change_status', function () {
        var $this = $(this), id = $this.attr('data-id'), status = $this.val();

        $.post("{$adminUrl}/feedbacks?action=change_status", { id: id, status: status }, function(response){
            new Noty({ text: response.message, type: response.type }).show();

        });
    })

</script>
