<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$generate_url}?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$generate_url}" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">

		<div class="row">
			<div class="col-md-8">
                {* основные поля *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-6 mb-3">
									<div class="form-group form-group-float">
										<label class="form-label {if isset($errors.sectionId)}text-danger{/if}">{general:section} *</label>
                                        {html_options options=$sections name="article[sectionId]" id="sectionId" selected=$article.sectionId|default:0 class="form-control form-control-sm select"}
									</div>
								</div>
								<div class="col-md-6 mb-3">
									<div class="form-group form-group-float">
										<label class="form-label {if isset($errors.countryId)}text-danger{/if}">Город *</label>
                                        {html_options options=$countries name="article[countryId]" id="countryId" selected=$article.countryId|default:0 class="form-control form-control-sm select"}
									</div>
								</div>
								<div class="col-md-6 mb-3">
									<div class="form-group">
										<label class="form-label {if isset($errors.title)}text-danger{/if}">{general:title} *</label>
										<input type="text" class="form-control" id="title" autocomplete="off" name="article[title]" value="{$article.title|default:''}" onblur="proposeFileName('title', 'fileName', 'article', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
									</div>
								</div>
								<div class="col-md-6 mb-3">
									<div class="form-group">
										<label class="form-label {if isset($errors.alias)}text-danger{/if}">Зароботная плата *</label>
										<input type="text" class="form-control" id="alias" autocomplete="off" name="article[alias]" value="{$article.alias|default:''}">
									</div>
								</div>
								<div class="col-md-12 mb-3">
									<div class="form-group">
										<label class="form-label {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
										<input  type="text" class="form-control" id="fileName" autocomplete="off" name="article[fileName]" value="{$article.fileName|default:''}" />
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
                {* /основные поля *}


                {* текст summary/content *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0 p-0">
							<ul class="nav nav-tabs nav-tabs-overline border-top-0">
								<li class="nav-item"><a href="#summary" class="nav-link active show" data-bs-toggle="tab">{general:tabs:summary}</a></li>
								<li class="nav-item"><a href="#content" class="nav-link" data-bs-toggle="tab">{general:tabs:content}</a></li>
							</ul>

							<div class="tab-content border-top-0 rounded-top-0 mb-0">
								<div class="tab-pane fade show active" id="summary">
									<textarea id="description" name="article[summary]" class="description">{if isset($article.summary)}{$article.summary}{/if}</textarea>
								</div>

								<div class="tab-pane fade" id="content">
									<textarea id="description" name="article[content]" class="description">{if isset($article.content)}{$article.content}{/if}</textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
                {* /текст описание *}

			</div>

			<div class="col-md-4">

                {* статус и видимость *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="article[status]" array=$statuses selected=$article.status|default:'visible' class="form-group mb-3"}
                            {* /field status *}

							<div class="form-group mb-3">
								<label class="form-label is-visible">{articles:misc:publishDate}</label>
								<div class="input-group">
									<span class="input-group-text"><i class="ph-calendar"></i></span>
									<input type="text" class="form-control date-range-single" name="article[publishedOn]" value="{$article.publishedOn|default:$adjustedNow}" readonly>
								</div>
							</div>

						</div>
                        {if isset($article.addedOn) && isset($article.modifiedOn)}
							<div class="card-footer hstack gap-3 justify-content-between">
								<div class="text-muted">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{general:created}</li>
										<li>{general:modified}</li>
									</ul>
								</div>
								<div class="hstack gap-1">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{$article.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$article.addedBy.loginName|default:"{general:unknownUser}"})</li>
										<li>{$article.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$article.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
									</ul>
								</div>
							</div>
                        {/if}
					</div>
				</div>
                {* /статус и видимость *}

                {* image preview *}
                {include file="components/image-preview.tpl"
                image="{if isset($article.image)}{$article.image.original}{/if}"
                id="{if isset($article.image)}{$article.image.imageId}{/if}"
                module='article'}
                {* /image preview *}
			</div>

			<div class="col-md-12 text-center">
                {if isset($article.articleId)}<input type="hidden" class="form-control" id="id" name="id" value="{$article.articleId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>


    $(document).ready(function () {

        {if isset($messages.saved)} new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.title)} new Noty({ text: '{articles:errors:1}', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.sectionId)} new Noty({ text: '{articles:errors:2}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.image_not_saved)} new Noty({ text: '{articles:errors:5}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileName)} new Noty({ text: '{articles:errors:7}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: '{articles:errors:8}', type: 'error', timeout: 2500 }).show(); {/if}


    });

</script>
