<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$generate_url}?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$generate_url}" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">

		<div class="row">
			<div class="col-md-8">
                {* основные поля *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-6 mb-3">
									<div class="form-group form-group-float">
										<label class="form-label {if isset($errors.sectionId)}text-danger{/if}">{general:section} *</label>
                                        {html_options options=$sections name="article[sectionId]" id="sectionId" selected=$article.sectionId|default:0 class="form-control form-control-sm select"}
									</div>
								</div>
								<div class="col-md-6 mb-3">
									<div class="form-group form-group-float">
										<label class="form-label {if isset($errors.countryId)}text-danger{/if}">Город *</label>
                                        {html_options options=$countries name="article[countryId]" id="countryId" selected=$article.countryId|default:0 class="form-control form-control-sm select"}
									</div>
								</div>
								<div class="col-md-6 mb-3">
									<div class="form-group">
										<label class="form-label {if isset($errors.title)}text-danger{/if}">{general:title} *</label>
										<input type="text" class="form-control" id="title" autocomplete="off" name="article[title]" value="{$article.title|default:''}" onblur="proposeFileName('title', 'fileName', 'article', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
									</div>
								</div>
								<div class="col-md-6 mb-3">
									<div class="form-group">
										<label class="form-label {if isset($errors.alias)}text-danger{/if}">Адрес *</label>
										<input type="text" class="form-control" id="alias" autocomplete="off" name="article[alias]" value="{$article.alias|default:''}">
									</div>
								</div>
								<div class="col-md-12 mb-3">
									<div class="form-group">
										<label class="form-label {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
										<input  type="text" class="form-control" id="fileName" autocomplete="off" name="article[fileName]" value="{$article.fileName|default:''}" />
									</div>
								</div>

								<div class="col-md-12 mb-3">
									<div class="form-group">
										<label class="form-label {if isset($errors.coordinates)}text-danger{/if}">Координаты *</label>
										<input  type="text" class="form-control" id="coordinates" autocomplete="off" name="article[coordinates]" value="{$article.coordinates|default:''}" />
									</div>
								</div>
								<div class="col-md-12 mb-3">
									<div class="form-group">
										<label class="form-label">Ориентир</label>
										<input  type="text" class="form-control" id="landmark" autocomplete="off" name="article[landmark]" value="{$article.landmark|default:''}" />
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
                {* /основные поля *}

                {* фото галерея *}
				<div class="collapse {if isset($article.enableGallery) and $article.enableGallery eq 1}show{/if}" id="gallery-card">
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">{general:card:imageLibrary}</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body">
								<div class="row gallery gallery-product gallery-sortable mt-2 sortable" id="fileList">
	                                {if isset($article.gallery)}
	                                    {foreach item=file from=$article.gallery}
											<figure class="gallery-item mb-0" id="gallery-item-{$file.imageId}" data-id="{$file.imageId}">
												<div class="move_zone image">
													<img src="{$file.medium}" alt="{$file.title|default:''}"/>
													<ul class="gallery-item-controls">
														<li><span>{$file.orderBy}</span></li>
														<li>
		                                                    <span class="edit_image" id="edit_image_{$file.imageId}"
		                                                          data-title="{$file.title}"
		                                                          data-alias="{$file.alias}"
		                                                          data-description="{$file.description}"
		                                                          data-link="{$file.link}"
		                                                          data-position="{$file.position}"
		                                                          onclick="editPictureInfo({$file.imageId}, 'Добавить описание к картинке', 'article');"><i class="ph-note-pencil"></i></span>
														</li>
														<li>
															<span onclick="deletePicture({$file.imageId}, 'article');"><i class="ph-trash"></i></span>
														</li>
													</ul>
												</div>
												<div class="meta" id="meta_image_{$file.imageId}">
													<span id="im_title" class="fs-sm fw-normal fw-semibold">{$file.title}</span>
													<span id="im_alias" class="fs-sm fw-normal">{$file.alias}</span>
													<span id="im_description" class="fs-sm fw-normal">{$file.description nofilter}</span>
													<span id="im_link" class="fs-sm fw-normal">{$file.link}</span>
													<span id="im_position" class="badge bg-primary text-white fs-sm fw-light">{$file.position}</span>
												</div>
											</figure>
	                                    {/foreach}
	                                {/if}
								</div>
							</div>

							<div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
								<button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="gallery" data-path="/" data-action="read_more"><i class="ph-image me-2"></i> {general:uploadFiles} </button>
								<button type="button" class="btn btn-sm btn-primary btn-sorting collapse" data-action="sortPictures" data-module="article"><i class="ph-check me-2"></i> {general:apply}</button>
							</div>
						</div>
					</div>
				</div>
                {* /фото галерея *}

                {* текст summary/content *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0 p-0">
							<ul class="nav nav-tabs nav-tabs-overline border-top-0">
								<li class="nav-item"><a href="#summary" class="nav-link active show" data-bs-toggle="tab">{general:tabs:summary}</a></li>
								<li class="nav-item"><a href="#content" class="nav-link" data-bs-toggle="tab">{general:tabs:content}</a></li>
							</ul>

							<div class="tab-content border-top-0 rounded-top-0 mb-0">
								<div class="tab-pane fade show active" id="summary">
									<textarea id="description" name="article[summary]" class="description">{if isset($article.summary)}{$article.summary}{/if}</textarea>
								</div>

								<div class="tab-pane fade" id="content">
									<textarea id="description" name="article[content]" class="description">{if isset($article.content)}{$article.content}{/if}</textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
                {* /текст описание *}

			</div>

			<div class="col-md-4">

                {* статус и видимость *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="article[status]" array=$statuses selected=$article.status|default:'visible' class="form-group mb-3"}
                            {* /field status *}

							<div class="form-check mb-3">
								<input type="checkbox" class="form-check-input" id="enableGallery" name="article[enableGallery]" value="1" {if isset($article.enableGallery) and $article.enableGallery eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#gallery-card">
								<label class="form-check-label" for="enableGallery">Фотогалерея к этой публикации</label>
							</div>

							<div class="form-group mb-3">
								<label class="form-label is-visible">{articles:misc:publishDate}</label>
								<div class="input-group">
									<span class="input-group-text"><i class="ph-calendar"></i></span>
									<input type="text" class="form-control date-range-single" name="article[publishedOn]" value="{$article.publishedOn|default:$adjustedNow}" readonly>
								</div>
							</div>

						</div>
                        {if isset($article.addedOn) && isset($article.modifiedOn)}
							<div class="card-footer hstack gap-3 justify-content-between">
								<div class="text-muted">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{general:created}</li>
										<li>{general:modified}</li>
									</ul>
								</div>
								<div class="hstack gap-1">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{$article.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$article.addedBy.loginName|default:"{general:unknownUser}"})</li>
										<li>{$article.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$article.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
									</ul>
								</div>
							</div>
                        {/if}
					</div>
				</div>
                {* /статус и видимость *}

                {* image preview *}
                {include file="components/image-preview.tpl"
                image="{if isset($article.image)}{$article.image.original}{/if}"
                id="{if isset($article.image)}{$article.image.imageId}{/if}"
                module='article'}
                {* /image preview *}
			</div>

			<div class="col-md-12 text-center">
                {if isset($article.stationId)}<input type="hidden" class="form-control" id="id" name="id" value="{$article.stationId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>


    $(document).ready(function () {

        {if isset($messages.saved)} new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.title)} new Noty({ text: '{articles:errors:1}', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.sectionId)} new Noty({ text: '{articles:errors:2}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.image_not_saved)} new Noty({ text: '{articles:errors:5}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileName)} new Noty({ text: '{articles:errors:7}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: '{articles:errors:8}', type: 'error', timeout: 2500 }).show(); {/if}

        // сортировать фотогалерею
        $(document).on('click', '.sortable_save_button', function () {
            var ids = new Array();
            $('#fileList figure.gallery-item').each(function () {
                console.log($(this).attr('data-id'))

                ids.push($(this).attr('data-id'));
            })
            $.post( "{$generate_url|substr:0:-1}?action=sortPictures", { imageIds : ids }, function() {
                $('.sortable_footer_navbar').removeClass('show');
                $("#fileList").load(location.href + " figure.gallery-item");
                new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
            });
        })
        $(document).on('click', '.sortable_cancel_button', function () {
            $('.sortable_footer_navbar').removeClass('show');
            $("#fileList").load(location.href + " figure.gallery-item");
        })


    });

</script>
