
<!-- Page header -->
{capture name="buttons"}
{/capture}
{capture name="breadcrumb"}
	<a href="{$adminUrl}/backup" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
{/capture}

{capture name="showBy"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<div class="content">

	<div class="card">
		<div class="card-header p-0">
			<ul class="nav nav-tabs nav-tabs-overline nav-tabs-highlight fs-base border-top-0">

				<li class="nav-item">
					<a class="nav-link fs-sm active show" href="#backup" data-bs-toggle="tab">
						<div class="d-flex align-items-center">
							<i class="ph-file-zip  bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
							<span class="fw-semibold">{backup:tabs:backup}</span>
						</div>
					</a>
				</li>
                {*					<li class="nav-item">*}
                {*						<a class="nav-link fs-sm" href="#setup" data-bs-toggle="tab">*}
                {*							<div class="d-flex align-items-center">*}
                {*								<i class="ph-files bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>*}
                {*								<span class="fw-semibold">{backup:tabs:setup}</span>*}
                {*							</div>*}
                {*						</a>*}
                {*					</li>*}

				<li class="nav-item">
					<a class="nav-link fs-sm" href="#restore" data-bs-toggle="tab">
						<div class="d-flex align-items-center">
							<i class="ph-file-arrow-down bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
							<span class="fw-semibold">{backup:tabs:backup}</span>
						</div>
					</a>
				</li>
				<li class="nav-item">
					<a class="nav-link fs-sm" href="#manage" data-bs-toggle="tab">
						<div class="d-flex align-items-center">
							<i class="ph-file-arrow-up bg-primary text-primary bg-opacity-10 rounded p-1 me-2"></i>
							<span class="fw-semibold">{backup:tabs:manage}</span>
						</div>
					</a>
				</li>

			</ul>
		</div>
		<div class="card-body flex-column flex-md-row m-0 p-0">
			<div class="tab-content mb-0 p-3">
				<div class="tab-pane fade show active" id="backup">
					<form method="post" autocomplete="off"  class="form-content-wrapper">
						<div class="form-group row">
							<label class="col-form-label col-lg-6">{backup:makeBackupNote}</label>
							<div class="col-lg-6">
								<button class="btn btn-sm btn-primary" type="submit" name="action" value="makeBackup" >&nbsp; {backup:makeBackup}&nbsp;</button>
							</div>
						</div>
					</form>
				</div>

                {*					<div class="tab-pane fade" id="setup">
										<form method="post" autocomplete="off"  class="form-content-wrapper">
											<fieldset class="">

												<div class="form-group row">
													<label class="col-form-label col-lg-6">{articles:title}<br> <span class="p-0 font-size-sm font-italic text-muted">{backup:articlesLabel}</span></label>
													<div class="col-lg-6">
														<div class="form-check mb-2">
															<input type="checkbox" class="form-check-input" id="articles" name="backup[articles]" value="1">
															<label class="form-check-label" for="articles">{articles:title}</label>
														</div>
													</div>
												</div>
												<div class="form-group row">
													<label class="col-form-label col-lg-6">{sections:title}<br><span class="p-0 font-size-sm font-italic text-muted">{backup:sectionsLabel}</span></label>
													<div class="col-lg-6">
														<div class="form-check mb-2">
															<input type="checkbox" class="form-check-input" id="sections" name="backup[sections]" value="1">
															<label class="form-check-label" for="sections">{sections:title}</label>
														</div>
													</div>
												</div>
												<div class="form-group row">
													<label class="col-form-label col-lg-6">{comments:title}<br /><span class="p-0 font-size-sm font-italic text-muted">{backup:commentsLabel}</span></label>
													<div class="col-lg-6">
														<div class="form-check mb-2">
															<input type="checkbox" class="form-check-input" id="comments" name="backup[comments]" value="1">
															<label class="form-check-label" for="comments">{comments:title}</label>
														</div>
													</div>
												</div>
												<div class="form-group row">
													<label class="col-form-label col-lg-6">{header:statistics}<br /><span class="p-0 font-size-sm font-italic text-muted">{backup:statsLabel}</span></label>
													<div class="col-lg-6">
														<div class="form-check mb-2">
															<input type="checkbox" class="form-check-input" id="statistics" name="backup[statistics]" value="1">
															<label class="form-check-label" for="statistics">{header:statistics}</label>
														</div>
													</div>
												</div>

												<div class="form-group row mb-3">
													<label class="col-form-label col-lg-6">{users:title}</label>
													<div class="col-lg-6">
														<div class="form-check mb-2">
															<input type="radio" class="form-check-input" id="usersLabelYes" name="backup[users]" value="1">
															<label class="form-check-label" for="usersLabelYes">{backup:usersLabelYes}</label>
														</div>
														<div class="form-check mb-2">
															<input type="radio" class="form-check-input" id="usersLabelNo" name="backup[users]" value="0">
															<label class="form-check-label" for="usersLabelNo">{backup:usersLabelNo}</label>
														</div>
													</div>
												</div>
												<div class="form-group row">
													<label class="col-form-label col-lg-6">{backup:makeSetupNote}</label>
													<div class="col-lg-6">
														<button class="btn btn-sm btn-primary" type="submit" name="action" value="makeSetup" >&nbsp;  {backup:makeSetup} &nbsp;</button>
													</div>
												</div>
											</fieldset>
										</form>
									</div>*}

				<div class="tab-pane fade" id="restore">
					<form method="post" autocomplete="off"  class="form-content-wrapper">
						<fieldset class="">
							<div class="form-group row mb-3">
								<label class="col-form-label col-lg-6">{backup:restoreFromLocal}</label>
								<div class="col-lg-6">
                                    {if $backupFiles}
										<div class="input-group">
                                            {html_options output=$backupFiles values=$backupFiles name="backup[fileName]" class="form-control select" data-width="300"}
											<button class="btn btn-sm btn-primary" type="submit" name="action" value="restoreFromFile" >{backup:makeSetup}</button>
										</div>
                                    {else}
                                        {backup:noFilesToRestore}
                                    {/if}
								</div>
							</div>
							<div class="form-group row">
								<label class="col-form-label col-lg-6">{backup:restoreFromUpload}</label>
								<div class="col-lg-6">
									<div class="input-group">
										<input class="form-control" type="file" name="fileToRestore" value="">
										<button class="btn btn-sm btn-primary" type="submit" name="action" value="restoreFromUpload" >&nbsp;  {backup:restore} &nbsp;</button>
									</div>
								</div>
							</div>
						</fieldset>
					</form>
				</div>

				<div class="tab-pane fade" id="manage">
					<form method="post" autocomplete="off"  class="form-content-wrapper">
						<fieldset class="">
							<div class="form-group row">
                                {if $backupFiles}
									<div class="input-group">
                                        {html_options output=$backupFiles values=$backupFiles name="backup[fileName]" class="form-control select" data-width="300"}
										<button class="btn btn-sm btn-primary" type="submit" name="action" value="downloadFile" >{backup:download}</button>
										<button class="btn btn-sm btn-primary" type="submit" name="action" value="deleteFile" >{general:delete}</button>
									</div>
                                {else}
                                    {backup:noFilesToManage}
                                {/if}
							</div>

						</fieldset>
					</form>
				</div>

			</div>
		</div>
	</div>


</div>


<script>
    $(document).ready(function() {
        {if isset($messages.backupCreated)} new Noty({ text: '{backup:messages:0}', type: 'success' }).show(); {/if}
        {if isset($messages.setupCreated)} new Noty({ text: '{backup:messages:1}', type: 'success' }).show(); {/if}
        {if isset($messages.fileDeleted)} new Noty({ text: '{backup:messages:2}', type: 'success' }).show(); {/if}
        {if isset($messages.restoreComplete)} new Noty({ text: '{backup:messages:3}', type: 'success' }).show(); {/if}

        {if isset($errors.fileNotFound)} new Noty({ text: '{backup:errors:0}', type: 'error' }).show(); {/if}
        {if isset($errors.unableToDeleteFile)} new Noty({ text: '{backup:errors:1}', type: 'error' }).show(); {/if}
    });
</script>



