{if isset($action) && $action == 'edit'}

	<script type="text/javascript" src="/admin/assets/js/codemirror/codemirror.js"></script>
	<script type='text/javascript' src="/admin/assets/js/codemirror/mode/htmlmixed/htmlmixed.js"></script>
	<script type='text/javascript' src="/admin/assets/js/codemirror/mode/xml/xml.js"></script>
	<script type='text/javascript' src="/admin/assets/js/codemirror/mode/javascript/javascript.js"></script>
	<script type='text/javascript' src="/admin/assets/js/codemirror/mode/css/css.js"></script>
	<script type='text/javascript' src="/admin/assets/js/codemirror/mode/clike/clike.js"></script>
	<script type='text/javascript' src="/admin/assets/js/codemirror/mode/php/php.js"></script>

	<form class="form-content-wrapper" action="{$adminUrl}/filemanager" method="post" id="template">
		<input type="hidden" name="path" value="{if isset($path)}{$path}{/if}" />
		<input type="hidden" name="file[name]" value="{if isset($file.name)}{$file.name}{/if}" />

		<!-- Page header -->
        {capture name="buttons"}
	        <button class="btn btn-sm btn-primary" type="submit" name="action" value="save" id="submitButton"> &nbsp; {general:save} &nbsp;</button> &nbsp;
	        <a class="btn btn-sm btn-primary" href="{$adminUrl}/filemanager{if isset($path)}?path={$path}{/if}">{general:cancel}</a>
        {/capture}

        {capture name="breadcrumb"}
			<a href="{$adminUrl}/filemanager" class="breadcrumb-item">{$title}</a>
        {/capture}

        {capture name="showBy"}{/capture}

        {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
		<!-- /page header -->

		<div class="content">
			<div class="row">
				<div class="col-md-12">
					<div class="card">
						<div class="card-header bg-transparent header-elements-inline">
							<h6 class="card-title">Редактирование файла <b>{$file.name}</b></h6>
							<div class="header-elements">
								<div class="list-icons">
									<a class="list-icons-item" data-action="collapse"></a>
								</div>
							</div>
						</div>

						<textarea id="codeEditor" name="file[content]">{if isset($file.content)}{$file.content|escape nofilter}{/if}</textarea>
					</div>
					<div class="d-flex justify-content-center p-2">
						<button class="btn btn-sm btn-primary" type="submit" name="action" value="save" id="submitButton"> &nbsp; {general:save} &nbsp;</button> &nbsp;
						<a class="btn btn-sm btn-primary" href="{$adminUrl}/filemanager{if isset($path)}?path={$path|escape}{/if}">{general:cancel}</a>
					</div>

				</div>

			</div>
		</div>

	</form>

	<script>
        window.onload = function() {
            var editor = CodeMirror.fromTextArea(document.getElementById("codeEditor"), {
                indentUnit: 4,
                lineNumbers: true,
                matchBrackets: true,
                mode: "application/x-httpd-php",
                indentUnit: 4,
                indentWithTabs: true,
                enterMode: "keep",
                tabMode: "shift"
            });
            editor.setSize('100%','420px');
        };
	</script>


{else}



	<!-- Page header -->
    {capture name="buttons"}
	    <button class="btn btn-sm btn-primary" data-toggle="collapse" data-target="#add_folder">{fileManager:addFolder}</button>&nbsp;&nbsp;
	    <button class="btn btn-sm btn-primary" data-toggle="collapse" data-target="#file_upload">{fileManager:uploadFile}</button>
    {/capture}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/filemanager" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-12">

				<div class="card collapse" id="file_upload">
					<div class="card-header bg-transparent header-elements-inline">
						<h6 class="card-title">{fileManager:addFolder}</b></h6>
					</div>
					<div class="card-body">
						<div id="upload_files" class="dropzone">
							<div class="dz-default dz-message"></div>
							<input type="hidden" name="send_path" value="{if isset($path)}{$path|escape}{else}/{/if}" id="send_path">
						</div>
					</div>
				</div>

				<div class="card collapse" id="add_folder">
					<div class="card-header bg-transparent header-elements-inline"><h6 class="card-title">{fileManager:addFolder}</b></h6></div>
					<div class="card-body">
						<form method="post">
							<div class="row justify-content-md-center">
								<div class="col-md-6">
									<input class="form-control" type="text" name="folder[name]" placeholder="{fileManager:folderName}">
								</div>
								<div class="col-md-2">
									<button class="btn btn-sm btn-primary" type="submit" name="action" value="add_folder"><i class="icon-folder-plus2"></i> {fileManager:add}</button>
								</div>
							</div>
						</form>
					</div>
				</div>

				<div class="card">
					<div class="">
						<table class="table table-togglable table-xs table-striped table-hover footable-loaded footable">
							<thead>
							<tr>
								<th class="text-left pl-4">{fileManager:file}</th>
								<th class="text-center" width="80">{fileManager:size}</th>
								<th class="text-center" width="120">{general:modified}</th>
								<th class="text-center" width="100">{general:action}</th>
							</tr>
							</thead>
							<tbody>
		                    {if isset($upPath) AND $upPath ne $path}
								<tr>
									<td class="data" colspan="4">
										<a href="{$adminUrl}/filemanager{if isset($upPath)}?path={$upPath}{/if}" style="font-size: 14px;margin-right: 10px;color: #3c5a96;">
											<i class="icon-undo2" aria-hidden="true"style="margin-right: 5px;color: #3c5a96;"></i> {fileManager:back}
										</a>
									</td>
								</tr>
		                    {/if}

		                    {if isset($list)}
		                        {if isset($list.dirs)}
		                            {foreach item=dir from=$list.dirs}
										<tr>
											<td class="data"><a href="{$adminUrl}/filemanager?path={$path|escape}{$dir.name}"><i class="icon-folder" aria-hidden="true" style="font-size: 18px;margin-right: 10px;color: #da9101;"></i>{$dir.name}</a></td>
											<td></td>
											<td class="text-center" nowrap="nowrap">{$dir.mtime|format_time:"d.m.Y H:i:s"}</td>
											<td class="text-end">
												<button type="button" class="btn btn-sm btn-link legitRipple" onclick="deleteFile('{$path|escape}', '{$dir.name|escape}', 'filemanager')" />
												<i class="ph-trash"></i></button>
											</td>
										</tr>
		                            {/foreach}
		                        {/if}

		                        {if isset($list.files)}
		                            {foreach item=file from=$list.files}
										<tr>
											<td><i class="icon-file-xml2" aria-hidden="true" style="font-size: 18px;margin-right: 10px;margin-left: 10px;color: #3c5a96;"></i> {$file.name}</td>
											<td nowrap="nowrap" align="right">{$file.size|fsize_format}</td>
											<td class="text-center" nowrap="nowrap">{$file.mtime|format_time:"d.m.Y H:i"}</td>
											<td class="d-flex justify-content-center">
												<a class="btn btn-sm btn-default" href="{$adminUrl}/filemanager?action=edit&path={$path|escape}&file[name]={$file.name|escape:url}"><i class="icon-pencil7"></i></a>
												<button type="button" class="btn btn-sm btn-link legitRipple" onclick="deleteFile('{$path|escape}', '{$file.name|escape}', 'filemanager')" /><i class="ph-trash"></i></button>
											</td>
										</tr>
		                            {/foreach}
		                        {/if}
		                    {/if}
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
{/if}

<script>
    $(document).ready(function () {
        {if isset($errors.upload)} new Noty({ text: '{fileManager:errors:0}', type: 'error' }).show(); {/if}
        {if isset($errors.folder)} new Noty({ text: '{fileManager:errors:1}', type: 'error' }).show(); {/if}
        {if isset($errors.deleteFile)} new Noty({ text: '{fileManager:errors:2}', type: 'error' }).show(); {/if}
        {if isset($errors.deleteFolder)} new Noty({ text: '{fileManager:errors:3}', type: 'error' }).show(); {/if}
        {if isset($errors.save)} new Noty({ text: '{fileManager:errors:4}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameCharacters)} new Noty({ text: '{fileManager:errors:5}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameNoDot)} new Noty({ text: '{fileManager:errors:6}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameProhibited)} new Noty({ text: '{fileManager:errors:7}', type: 'error' }).show(); {/if}
        {if isset($errors.accessDenied)} new Noty({ text: '{fileManager:errors:8}', type: 'error' }).show();{/if}
        {if isset($errors.fileNotFound)} new Noty({ text: '{fileManager:errors:9}', type: 'error' }).show(); {/if}

        {if isset($messages.folder)} new Noty({ text: '{fileManager:messages:0}', type: 'success' }).show(); {/if}
        {if isset($messages.uploaded)} new Noty({ text: '{fileManager:messages:1}', type: 'success' }).show(); {/if}
        {if isset($messages.deletedFile)} new Noty({ text: '{fileManager:messages:2}', type: 'success' }).show(); {/if}
        {if isset($messages.deletedFolder)} new Noty({ text: '{fileManager:messages:3}', type: 'success' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: '{fileManager:messages:4}', type: 'success' }).show(); {/if}
    });
    function uploadMessage(){ new Noty({ text: '{fileManager:messages:5}', layout: 'topRight', type: 'success' }).show(); }

    Dropzone.autoDiscover = false;
    $(document).ready(function () {
        $("#upload_files").dropzone({
            dictDefaultMessage:             lang['dictDefaultMessage'],
            dictFallbackMessage:            lang['dictFallbackMessage'],
            dictFallbackText:               lang['dictFallbackText'],
            dictFileTooBig:                 lang['dictFileTooBig'],
            dictInvalidFileType:            lang['dictInvalidFileType'],
            dictResponseError:              lang['dictResponseError'],
            dictCancelUpload:               lang['dictCancelUpload'],
            dictCancelUploadConfirmation:   lang['dictCancelUploadConfirmation'],
            dictRemoveFile:                 lang['dictRemoveFile'],
            dictRemoveFileConfirmation:     lang['dictRemoveFileConfirmation'],
            dictMaxFilesExceeded:           lang['dictMaxFilesExceeded'],
            paramName: "file",
            url: "{$adminUrl}/filemanager",
            addRemoveLinks: true,
            maxFilesize: 256,
            maxFiles: 100,
            params: { action: 'upload' },
            init: function () {
                this.on('sending', function (file, xhr, formData) {
                    $('.dz-message').css('opacity', 0);
                    formData.append('path', $('#send_path').val());
                });
                this.on("success", function (file, response) {
                    console.log('dropzone success => ', response)
                    if (response.status === 200) {
                        new Noty({ text: response.message, type: 'success' }).show();
                        setTimeout(function(){
                            location.reload();
                        }, 600);
                    } else {
                        $(file.previewElement).find('.dz-error-mark').css('display', 'block').css('opacity', 1);
                        new Noty({ text: response.message, type: 'error' }).show();
                    }
                });
                this.on("queuecomplete", function () {

                });
                this.on('error', function (file, response) {
                    $(file.previewElement).find('.dz-error-message');
                    new Noty({ text: response.error, type: 'error' }).show();
                });
            },
            accept: function(file, done) {
                return done();
            }
        });
    });
</script>




