<?php

    $L['codeName']    = 'ru';
	$L['langName']    = 'Русский';
	$L['charset']     = 'utf-8';
	$L['productName'] = 'Life Style CMS';

	$L['header'] = array(
		'statistics'         => 'Статистика',
		'content'            => 'Контент',
		'administration'     => 'Управление',
		'administrationSite' => 'Система',
		'viewWebsite'        => 'Перейти на сайт',
		'signOut'            => 'Выйти?',
		'signOutLeave'       => 'Вы действительно хотите выйти?',
		'signOutYes'         => 'Да',
		'signOutNo'          => 'Нет',
		'contacts'           => 'Контакты',
		'copyright'          => 'Создание и продвижение сайтов',
		'forgotPassword'     => 'Забыли пароль?',
		'techSupport'        => 'Напишите в техподдержку',
	);

	$L['login'] = array (
		'title'       => 'Вход в админ-панель',
		'username'    => 'Пользователь',
		'password'    => 'Пароль',
		'captcha'     => 'CAPTCHA',
		'captchaDesc' => 'Полностью автоматизированный публичный тест Тьюринга для различения компьютеров и людей',
		'signIn'      => 'Вход в админ-панель',
		'banned'      => 'Ваш IP забанен на 10 часов.',
		'errors'      => array (
			'Введенные имя пользователя и пароль неверные.',
			'Вы вышли из системы администрирования.',
			'Вы уже вышли из системы администрирования.',
			'Введите имя пользователя и пароль.',
			'Введите цифры, отображенные на картинке.',
			'Введите имя пользователя.',
			'Введите пароль.',
            'Введенные имя пользователя и пароль неверные.',
		)
	);

	$L['settings'] = array(
    	
		'title'       => 'Настройки',
		'linksSocial' => 'Ссылки на социальные сети',
		'social'      => 'Социальные сети',
		'addSettings' => 'Дополнительные настройки',
		'settings'    => 'настройки',

		'tabs' => array(
  		    'contact'           => 'Контакты',
			'general'           => 'Основные',
			'regional'          => 'Региональные настройки',
			'image'             => 'Изображения',
			'products'          => 'Продукция',
			'tidings'           => 'Новости',
			'comments'          => 'Комментарии',
			'caching'           => 'Оптимизация',
			'users'             => 'Посетители',
			'statistics'        => 'Статистика',
			'miscellaneous'     => 'Разное',
			'pochta'            => 'Почта',
			'security'          => 'Безопасность',
			'telegram'          => 'TelegramBotApi',
			'updateUrl'         => 'Update urls',
            'sms'               => 'Смс шлюз',
		),

		'general' => array(
			'websiteName'      => 'Название сайта',
			'websiteNameOp'    => 'например: «Моя домашняя страница»',
			'websiteCopyright' => 'Copyright',
			'websiteDeveloper' => 'Разработчик',
			'websiteTheme'     => 'Шаблон сайта по умолчанию',
			'websiteThemeOp'   => 'Выберите шаблон, который будет использоваться на сайте',
            'websiteImage'     => 'Изображение темы сайта',
            'geoLocation'      => 'Карта',
			'feedbackEmail'    => 'Информационные почтовые адреса',
			'feedbackEmailOp'  => 'Информационные почтовые адреса для вывода на сайт. <br>Можно указать несколько почтовых адресов через запятую',
            'address'=>'Адрес',
            'addressOp'=>'Укажите юридический адрес вашей компании',
            'phone'=>'Основной телефон',
            'phoneTwo'=>'Доп. телефон',
            'phoneThree'=>'Телефон менеджера',
			'feedbackCaptcha'=>'Контактная форма (CAPTCHA)',
			'feedbackCaptchaOp'=>'Включить каптчу (CAPTCHA) от спама, который будет использоваться на сайте.',
			'feedbackTypeCaptcha'=>'Тип кода безопасности (CAPTCHA):',
			'feedbackTypeCaptchaOp'=>'Укажите тип кода безопасности, который будет использоваться на сайте. Вы можете установить использование стандартную капчу, либо установить код сервиса reCAPTCHA:v3',
			'recaptchaPublicKey'=>'Публичный ключ сервиса reCAPTCHA:v3:',
			'recaptchaPublicKeyOp'=>'Получить ключ вы можете по ссылке: <a href="http://www.google.com/recaptcha" target="_blank">http://www.google.com/recaptcha</a><br /> Внимание, настоятельно рекомендуется зарегистрироваться на сервисе и сгенерировать для своего сайта уникальную пару ключей, установив разрешение на использование только на своем домене. Использование стандартной пары ключей, не дает должного эффекта по защите от спам роботов.',
			'recaptchaSecretKey'=>'Секретный ключ сервиса reCAPTCHA:v3:',
			'recaptchaSecretKeyOp'=>'Получить ключ вы можете по ссылке: <a href="http://www.google.com/recaptcha" target="_blank">http://www.google.com/recaptcha</a><br /> Внимание, настоятельно рекомендуется зарегистрироваться на сервисе и сгенерировать для своего сайта уникальную пару ключей, установив разрешение на использование только на своем домене. Использование стандартной пары ключей, не дает должного эффекта по защите от спам роботов.',
			'standartCaptcha'=>'Стандартный каптча',
			'reCaptcha'=>'reCAPTCHA:v3',
			'enabled'=>'Включено',
			'disabled'=>'Выключено',
			'websiteDown'=>'Выключение сайта',
			'websiteDownOp'=>'Перевести сайт в состояние offline, для проведения технических работ',
			'websiteDownMsg'=>'Сообщение посетителям, если сайт отключен',
			'websiteDownMsgOp'=>'Сообщение для отображения в режиме отключенного сайта',
			'contactInfomaciya'=>'Контактная инф-ция',
			'contactInfo'=>'Контактная информация',
			'operatingMode'=>'Режим работы',
			'operatingModeOp'=>'Укажите режим работы вашей организации',
			'companyName'=>'Название компании',
			'companyNameOp'=>'Название организации или юридическое название организации',
			'listip'=>'Список IP адресов',
			'listipInfo'=>'Список IP адресов разрешенных для просмотра сайта, когда сайт выключен.<br> Ваш IP адрес:',
		),
		
		'captchas' => array(
            '1' => 'Стандартный каптча',
            '2' => 'reCAPTCHA:v2',
            '3' => 'reCAPTCHA:v3',
		),
		'timeFormats' => array(
			'0' => '12-часовой',
			'1' => '24-часовой',
		),
		'fileExtension' => array(
			'htm'  => '.htm',
			'html' => '.html',
		),
		'separators' => array(
			'-' => '- (тире)',
			'_' => '_ (подчеркивание)',
		),
        'driver' => array(
			0   => 'Автоматически',
			1   => 'Imagick',
			2   => 'GD 2',
//			3   => 'Gmagick',
		),
        'generations' => array(
            'imagine'       => 'Imagine',
            'intervention' => 'Intervention'
        ),

		'regional' => array(
			'websiteLang'     => 'Используемый язык сайта',
			'websiteLangDesc' => 'Выберите язык, который будет использоваться, согласно языковой версии сайта',
			'adminLang'       => 'Используемый язык',
			'adminLangDesc'   => 'Выберите язык, который будет использоваться при работе с системой',
			'charset'         => 'Кодировка сайта',
			'charsetDesc'     => 'Кодировка сайта по умолчанию (Unicode - UTF-8), желательно не менять',
			'timeFormat'      => 'Формат времени',
			'timeFormatDesc'  => 'Формат времени по умолчанию (24-часовой)',
			'GMT'             => 'Среднее время по Гринвичу',
			'adjustHours'     => 'Часовой пояс',
			'adjustHoursDesc' => 'Выберете часовой пояс, по которому будет работать ваш сайт и сервер.<br /> Текущее время сервера с учетом часового пояса: {$adjustedTime nofilter}',
			'hours'           => 'часов',
			'minutes'         => 'минут',
            'mask'            => 'Маска для номера телефона',
            'maskDesc'        => 'Укажите формат маски для единого формата номера телефона в админ панели.<br /> Например ( +999 (99) 999-99-99 )',
		),
		
		'mails' => array(
      		'smtp_transport'   => 'Метод отправки почты',
      		'smtp_transportOp' => 'Если функция PHP mail() недоступна, выберите метод SMTP',
      		'smtp_subject'     => 'Заголовок отправителя писем, при отправке писем',
      		'smtp_subjectOp'   => 'При отправке писем с сайта вы можете указать заголовок, который будет добавляться к почте отправителя. <br />Например, вы можете там указать краткое название вашего сайта',
      		'smtp_email'       => 'Адрес отправителя (to)',
      		'smtp_emailOp'     => 'Введите E-Mail адрес администратора сайта. На этот адрес будут отправляться системные уведомления<br /> для администрации сайта, например, уведомления о новых комментариях и т.д.',
      		'smtp_server'      => 'SMTP Host',
      		'smtp_serverOp'    => 'Не требуется в большинстве случаев<br /> SMTP — localhost, smtp.yandex.ru, smtp.gmail.com',
      		'smtp_user'        => 'E-mail для авторизации на SMTP сервере в качестве отправителя',
      		'smtp_userOp'      => 'Данная настройка является необязательной, однако некоторые бесплатные почтовые сервисы,<br /> например yandex.ru, требуют, чтобы в качестве E-mail адреса отправителя был указан именно адрес,<br /> зарегистрированный на их почтовом сервисе.',
      		'smtp_pass'        => 'SMTP Пароль',
      		'smtp_passOp'      => 'Не требуется в большинстве случаев, когда используется "localhost"',
      		'smtp_port'        => 'SMTP Порт (Port)',
      		'smtp_portOp'      => 'Не требуется в большинстве случаев, когда используется "localhost"',
      		'smtp_secure'      => 'Использовать защищенный протокол для отправки писем через SMTP сервер',
      		'smtp_secureOp'    => 'Выберите протокол шифрования при отправке писем с использованием SMTP сервера',
			'ports' => array(
                ''    => 'По-умолчанию',
                '25'  => '25',
                '465' => '465',
                '587' => '587'
            ),
      		'secures'=>array(
          		''    => 'По-умолчанию',
      			''    => 'Без шифрования',
      			'ssl' => 'SSL',
      			'tls' => 'TLS'
      		),
      		'mailTransports' => array(
      			'mail' => 'PHP mail()',
      			'smtp' => 'SMTP'
      		),
		),
        'users' => array(
            'methodAuth'        => 'Метод авторизации на сайте',
            'methodAuthText'    => 'Вы можете выбрать, каким способом будет производиться авторизация пользователей на сайте.<br /> Доступно четыре варианта, либо с использованием своего `<b>Логина</b>`, с использованием `<b>E-mail</b>`,<br /> с использованием `<b>номером телефона</b>` или `<b>индивидуальная настройка</b>`. <br /> <span class="text-danger">Эти настройки производится один раз при разработке проекта и менять нельзя</span>.',
            'maxUserDay'        => 'Автоматическое удаление зарегистрированных пользователей',
            'maxUserDayText'    => 'Количество дней, через которое удалять пользователя, если он не посещал сайт <b>0 = ограничений нет</b>',
            'twoFactorAuth'     => 'Разрешить пользователям использование двухфакторной авторизации на сайте',
            'twoFactorAuthText' => 'При включении данной настройки, пользователям будет разрешено использование двухфакторной авторизации на сайте. При этом после ввода правильного пароля им на их номер телефона будет отправлен одноразовый пин код, которым они должны подтвердить авторизацию.',
            'smsUrl'            => 'Url сервера смс шлюза',
            'smsLogin'          => 'Ваш логин',
            'smsLoginInfo'      => 'При заключение договора Вам выдаются данные для авторизации смс шлюза',
            'smsPassword'       => 'Ваш пароль',
            'methods' => array(
                'login'  => 'По логину',
                'email'  => 'По E-Mail',
                'phone'  => 'По номеру телефона',
                'individual'  => 'Индивидуальная настройка'
            ),
        ),

        'telegrams' => array(
			'enabled'        => 'Включить телеграм',
			'enabledOp'      => 'Включить получение писем с сайта в телеграм',
			'token'          => 'Токен для доступа к HTTP API',
			'tokenOp'        => 'Сюда нужно вписать токен вашего бота',
			'chatId'         => 'Идентификатор чата',
			'chatIdOp'       => 'Сюда нужно вписать ваш внутренний идентификатор',
			'howToConnect'   => 'Как подключить',
			'howToConnectOp' => 'Первым делом надо зарегистрировать бота. Для этого надо зайти в приложение TelegramBotApi и открыть чат с <a href="https://t.me/@BotFather" target="_blank"  style="text-decoration: underline"> @BotFather</a>. Откроется список команд, где надо выбрать /newbot. Затем система попросит выбрать название бота и его имя, по которому бот будет доступен для поиска. Если к названию особых требований нет, то имя должно обязательно быть уникальным и заканчиваться на "bot".',
			'connectMessage' => 'Когда все основные параметры будут введены, система выдаст вам персональный токен, с помощью которого можно будет работать с ботом через HTTP-запросы. Никому не передавайте этот токен, чтобы никто посторонний не получил к нему доступ. Если все же произошла утечка данных, то через <a href="https://t.me/@BotFather" target="_blank" style="text-decoration: underline">@BotFather</a> можно сгенерировать новый токен для вашего бота.',
			'botEnabled'     => 'Если в настройках бота включен режим приватности (а он включен по умолчанию), то все сообщения, отправляемые ботом конкретному пользователю, не будут видны остальным подписчикам этого бота. Именно это нам и надо, ведь мы же не хотим, чтобы кто-то, случайно подписавшись на нашего бота, перехватывал все наши уведомления. Чтобы бот отправлял сообщения только нам, надо узнать идентификатор нашего чата.<br />Для этого подпишитесь на своего бота и отправьте ему любое сообщение. После этого в браузере надо сформировать ссылку следующего вида:<br /><a href="https://api.telegram.org/bot{$config.telegram_token}/getUpdates" target="_blank" style="text-decoration: underline">https://api.telegram.org/bot{$config.telegram_token}/getUpdates</a>',
			'doneRight'      => 'Если все сделано правильно, то в браузере откроется что-то подобное:<br />Красным цветом выделен нужный нам идентификатор чата. Если ответ пустой, то напишите боту еще парочку сообщений в чат и сразу же обновите страницу в браузере.',
			'keepImageName'  => 'Сохранять исходное имя картинки',
		),

		'map' => array(
			'settingMap'    => 'Настройки карты',
			'mapOff'        => 'Отключить карту',
			'mapOn'         => 'Включить карту',
			'mapApi'        => 'API ключ карты',
			'mapType'       => 'Тип карты',
			'coordinates'   => 'Координаты (lat, lng)',
			'heightMap'     => 'Высота карты',
			'zoomMap'       => 'Масштаб карты',
			'wightMap'      => 'Ширина карты',
			'fillColor'     => 'Цвет маркера',
			'fillOpacity'   => 'Прозрачность маркера',
			'scale'         => 'Размер маркера',
			'heightMapInfo' => 'Параметры карты по высоте ( для отображения на сайте ) указывать в пикселях ( px )',
			'wightMapInfo'  => 'Параметры карты по ширине ( для отображения на сайте ) указывать в процентах ( % )',
			'zoomMapInfo'   => 'Рекомендуемы параметры масштабирования карты (от 12 до 20)',
			'mapApiInfo'    => 'Удалять не рекомендуется (если Вам уже настроили карту)',
		),
		
		'article' => array(
  		    'slider'             => 'Включить слайдер на сайте',
			'article'            => 'Настойки изображений',
			'gallery'            => 'Настройки изображений для галереи',
			'smallThumbSize'     => 'Маленький размер (высота X ширина)',
			'mediumThumbSize'    => 'Средний размер (высота X ширина)',
			'largeThumbSize'     => 'Крупный размер (высота X ширина)',
			'thumbQuality'       => 'Качество сжатия',
			'saveOriginalImage'  => 'Сохранять исходную картинку',
            'saveThumbnailImage'  => 'Обрезать миниатюру точно по размерам',
			'keepImageName'      => 'Сохранять исходное имя картинки',
		),

		'comments' => array(
			'comments'              => 'Настройки комментариев',
			'enabledByDefault'      => 'Комментарии разрешены по-умолчанию',
			'enabledByDefaultText'  => 'Эта настройка может быть изменена для отдельных статей или разделов',
			'editorsApprove'        => 'Редакторы могут одобрять/удалять комментарии',
			'requireCaptcha'        => 'Требовать заполнения CAPTCHA',
			'contentModeration'     => 'Модерация контента комментариев',
			'stripTags'             => 'удалять HTML тэги',
			'convertUrls'           => 'конвертировать URL адреса в ссылки',
			'emailConfirmation'     => 'Подтверждение через email',
			'noConfirmation'        => 'Не требуется',
			'confirmationFirstTime' => 'Требуется если пользователь оставляет комментарий первый раз',
			'confirmationEachTime'  => 'Требуется для каждого комментария',
			'commentModeration'     => 'Модерация комментариев',
			'manualApprove'         => 'все комментарии одобряются вручную',
			'avoidApprove'          => 'публиковать комментарий если у пользователя уже были одобренные комментарии',
			'markAsSpam'            => 'отмечать комментарий как СПАМ, если у пользователя уже были подобные комментарии',
			'holdComment'           => 'Не публиковать комментарий',
			'markComment'           => 'Пометить комментарий как СПАМ',
			'markCommentText'       => 'Если в нем содержится:<br> Одно слово или IP в строке. <br>Проверяется на наличие в тексте комментария, имени автора, email и IP.',
		),

		'caching' => array(
			'caching'          => 'Настройки кеширования',
			'articles'         => 'Контент',
			'articlesText'     => 'Вы можете задать интервал в минутах, после которого будет осуществляться принудительная очистка кэша. Например задав 30, кеш будет очищаться каждые 30 минут. Данная настройка будет полезна если вы публикуете новости на будущую дату и включено кеширование на сайте.',
			'sections'         => 'Страницы, разделы',
			'sectionsText'     => 'Вы можете задать интервал в минутах, после которого будет осуществляться принудительная очистка кэша. Например задав 30, кеш будет очищаться каждые 30 минут. Данная настройка будет полезна если вы публикуете новости на будущую дату и включено кеширование на сайте.',
			'rss'              => 'RSS',
			'rssText'          => 'Вы можете задать интервал в минутах, после которого будет осуществляться принудительная очистка кэша. Например задав 30, кеш будет очищаться каждые 30 минут. Данная настройка будет полезна если вы публикуете новости на будущую дату и включено кеширование на сайте.',
			'sitemap'          => 'Карта сайта (XML)',
			'sitemapText'      => 'Вы можете задать интервал в минутах, после которого будет осуществляться принудительная очистка кэша. Например задав 30, кеш будет очищаться каждые 30 минут. Данная настройка будет полезна если вы публикуете новости на будущую дату и включено кеширование на сайте.',
			'clearCache'       => 'Очистка кэша шаблонов.',
			'clearCacheAction' => 'Очистить кеш',
			'clearedCache'     => 'Кэш очищен',
		),

		'statistics' => array(
			'statistics'   => 'Настройка статистики',
			'yandex'       => 'Ваш ID в Яндекс Метрике',
			'google'       => 'Ваш ID в Google Analytics',
			'enable'       => 'Включить статистику',
			'bot'          => 'Идентификаторы ботов',
			'query'        => 'Идентификаторы поисковых запросов',
			'deleteStats'  => 'Удалить статистические данные до',
			'statsDeleted' => 'Статистические данные удалены.',
		),
		
		'updateUrls' => array(
			'oldDomen' => 'Старый домен сайта',
			'oldDomenText' => 'Укажите старый адрес сайта',
			'newDomen' => 'Действующий домен сайта',
			'newDomenText' => 'Укажите новый или оставьте действующий адрес сайта',
		),

		'miscellaneous' => array(
			'miscellaneous' => 'Настройки файлов',
			'extension'     => 'Расширение файлов',
			'convert'       => 'Переводить имя файла в строчные',
			'compress'      => 'Включить Gzip сжатие JS и CSS файлов',
			'compressText'  => '<Если «Включено», то JavaScript и CSS файлы будут сжаты при помощи Gzip, это позволит уменьшить вес файлов до 70%, а также в 6 раз снизить количество HTTP запросов, что существенно ускоряет время загрузки ваших страниц.',
			'separator'     => 'Разделитель слов в имени файла',
			
		),

		'errors' => array(
			'Невозможно сохранить файл ".htaccess".',
			'Невозможно сохранить сериализационный файл.',
		),
		
		'messages' => array(
			'Настройки сохранены.',
		),
		
	);

	$L['stats'] = array(
    	
		'visitors'          => 'Посетители',
		'visits'            => 'Просмотры',
		'statisticsShow'    => 'Статистика просмотра',
		'visitor'           => 'Посетитель',
		'visit'             => 'Просмотр',
		'type'              => 'Тип',
		'returningVisitors' => 'Вернувшиеся посетители',
		'newVisitors'       => 'Новые посетители',
		'totalVisitors'     => 'Всего посетителей',
		'totalVisits'       => 'Всего просмотров',
		'rssHits'           => 'RSS хитов',
		'totals'            => 'Итого',
		'firstVisit'        => 'Первый визит',
		'referer'           => 'Источник',
		'useragent'         => 'Агенты',
		'code'              => 'Код',
		'requestUri'        => 'Запрашиваемый URI',
		'visitorId'         => 'ID посетителя',
		'errorInfo'         => 'Информация об ошибке',
		'unknown'           => 'неизвестно',
		'error'             => 'Ошибка',
		'allCodes'          => 'все коды',
		'ms'                => 'мс',
		'pageGenTime'       => 'Время генерации страниц',
		'visitorInfo'       => 'Информация о посетителе',
		'searchQuery'       => 'Поисковый запрос',
		'visitorIp'         => 'IP посетителя',
		'botInfo'           => 'Информация о Боте',
		'botIp'             => 'IP бота',
		'whois'             => 'whois',
		'page'              => 'Страница',
		'homePage'          => 'Домашняя страница',
		'genRss'            => 'Основной RSS',
		'genSitemap'        => 'Основная карта сайта',
		'xmlSitemap'        => 'Карта сайта в XML',
		'overviewTitle'     => 'Обзор',
		'visitorsTitle'     => 'Посетители',
		'referersTitle'     => 'Источники',
		'botsTitle'         => 'Боты',
		'errorsTitle'       => 'Ошибки',
		'performanceTitle'  => 'Производительность',
		'show'              => 'Показать',

		'periods' => array(
    		
			'today'      => 'сегодня',
			'yesterday'  => 'вчера',
			'last7days'  => 'последние 7 дней',
			'last14days' => 'последние 14 дней',
			'last30days' => 'последние 30 дней',
			'thisMonth'  => 'текущий месяц',
			'lastMonth'  => 'прошлый месяц',
			'allTime'    => 'все время',
		),

		'errorCodes' => array(
    		
			404 => 'Страница не найдена',
			503 => 'Сервис недоступен',
			301 => 'Перемещено',
		),

		'types' => array(
    		
			'allVisits' => 'Все просмотры',
			'sections'  => 'Страницы',
			'articles'  => 'Контент',
			'searches'  => 'Поиски',
			'errors'    => 'Ошибки',
			//'rss'=>'rss',
			//'sitemap'=>'Карта сайта',
		),
	);

	$L['general'] = array(
        'yes'              => 'Да',
        'no'               => 'Нет',
        'ok'               => 'OK',
        'cancel'           => 'Отменить',
        'view'             => 'Посмотреть',
        'update'           => 'Обновить',
        'change'           => 'Изменить',
        'edit'             => 'Редактировать',
        'save'             => 'Сохранить',
        'sort'             => 'Сортировать',
        'orderBy'          => 'Сортировка',
        'add'              => 'Добавить',
        'adding'           => 'Добавление',
        'editing'          => 'Редактирование',
        'search'           => 'Поиск',
        'filter'           => 'Фильтр',
        'choose'           => 'Выбрать',
        'apply'            => 'Применить',
        'action'           => 'Действие',
        'select'           => 'Выберите',

        'status'           => 'Статус',
        'restatus'         => 'Статус изменен',
        'erestatus'        => 'Ошибка изменения статуса',

        'content'          => 'Контент',
        'structure'        => 'Структура',
        'settingsProducts' => 'Настройки продукции',
        'uploadFile'       => 'Загрузить файл',
        'changeFile'       => 'Заменить файл',
        'uploadFiles'      => 'Загрузить файлы',

        'showAll'          => 'Показать все',
        'approve'          => 'Одобрить',
        'preview'          => 'Предпросмотр',
        'featured'         => 'Избранная',
        'allSections'      => 'Все разделы',
        'attachment'       => 'Прикрепленный файл',
        'attachmentView'   => 'Скачать прикрепленный файл',
        'attachmentDelete' => 'Удалить прикрепленный файл',
        'uploadedImages'   => 'Загруженные изображения',
        'addText'          => 'Добавьте текст к картинке',
        'selectFile'       => 'Выберите файл',
        'download'         => 'Загрузить',
        'fileDescription'  => 'Описание',
        'image'            => 'Картинка',

        'favorites'        => 'Избранное',
		'order'            => 'Заказы',

		'product'          => 'Наименование',
		'slider'           => 'Слайдер',
		'topMenu'          => 'Меню',
		'siteStructure'    => 'Структура сайта',
		'sections'         => 'Разделы',
		'selectedSection'  => 'Выберите раздел',
		'galleries'        => 'Галерея',
		'section'          => 'Раздел',
		'site_user'        => 'Пользователи',
		'template'         => 'Шаблон',
		'caching'          => 'Кэширование',
		'filename'         => 'URL',
		'alias'            => 'Альтернативное имя',
		'icon'             => 'Иконка',
		'contentType'      => 'Тип контента',
		'title'            => 'Заголовок',

		'date'             => 'Дата',
		'moveUp'           => 'Переместить вверх',
		'moveDown'         => 'Переместить вниз',
		'delete'           => 'Удалить',
		'result'           => '{if isset($pageNums.startIteration)}<span class="fw-semibold">{$pageNums.startIteration}-{$pageNums.endIteration}</span> из <span class="fw-semibold">{$pageNums.totalItems}</span>{else} <b>0</b>{/if}',
		'results'          => 'Результаты {if isset($pageNums.startIteration)}с <b>{$pageNums.startIteration}</b> по <b>{$pageNums.endIteration}</b> из <b>{$pageNums.totalItems}</b>{else} <b>0</b>{/if}',
		'prevPage'         => 'Пред.',
		'nextPage'         => 'След.',
		'none'             => 'Не найдено',
		'asterisk'         => 'Все поля, отмеченные звездочкой (<span class="text-danger">*</span>), должны быть заполнены.',
		'modified'         => 'Изменено',
		'created'          => 'Создано',

		'unknownUser'        => 'Неизвестный пользователь',
		'isNotSpecified'     => 'Не указан',
		'enableCachingFor'   => 'Включить кэширование на',
		'useDefaultTemplate' => 'Шаблон по умолчанию',
		'accessIsDenied'     => 'Доступ запрещен',
		'cachingDefault'     => 'Настройки по умолчанию',
		'cachingDisabled'    => 'Отключить кэширование',
		
		'notAvailable'   => 'Не доступно',
		'additionally'   => 'Дополнительно',
		'aboutProject'   => 'О проекте',
		'documentation'  => 'Документация',
		'manageTemplate' => 'Управление шаблоном',
		'subscribe'      => 'Рассылка писем',
		'maxFileUploads' => 'Максимальный размер загружаемого файла: 32 МБ.',

		'name'      =>'Имя',
		'fullName'  =>'Полное имя',
		'loginName' =>'Логин',
		'email'     =>'E-mail',
		'comments'  =>'Комментарии',
		'defaultComments'      => 'Настройки по умолчанию',
		'disableComments'      => 'Отключить комментарии',
		'enableComments'       => 'Включить комментарии',
		'metaTitle'            => 'Заголовок (Meta title)',
		'keywords'             => 'Ключевые слова (Meta keywords)',
		'description'          => 'Описание (Meta description)',
		'editImadeGallery'     => 'Добавить описание к картинке',
		'editDescImadeGallery' => 'Описание к картинке',
		'editLinkImadeGallery' => 'Переход(ссылка) с картинки',

        'cachingPeriodOptions' => array(
            60    => 'минут',
            3600  => 'часов',
            86400 => 'дней',
        ),
		'table'     => array(
			'id'          => 'ID',
			'name'        => 'Заголовок',
			'alias'       => 'Альтернативное имя',
			'path'        => 'Путь',
			'type'        => 'Тип',
			'typeContent' => 'Тип контента',
			'status'      => 'Статус',
			'topMenu'     => 'Меню',
			'action'      => 'Действие',
            'date'        => 'Дата',
            'image'       => 'ФОТО',
            'section'     => 'Раздел',
            'featured'    => 'Избранная',
            'num'         => '№',
            'price'       => 'Цена',
            'count'       => 'Кол-во',
            'variable'    => 'ПЕРЕМЕННАЯ',
            'transfer'    => 'ПЕРЕВОД',
            'email'       => 'Email',
            'eventType'   => 'Тип события',
            'user'        => 'Пользователь',
            'record'      => 'Запись',
            'pathFile'    => 'Путь к файлу',
            'file'        => 'ФАЙЛ',
            'size'        => 'РАЗМЕР',
            'url'         => 'URL',
            'title'       => 'Название',
            'product'     => 'Наименование',
            'favorites'   => 'Избранные',
		),
        'statuses'  => array(
            '0' => 'Выберите статус',
            'V' => 'Включено',
            'H' => 'Скрыто',
            'P' => 'В ожидании',
        ),
        'works'  => array(
            1   => 'Включен',
            0   => 'Выключен'
        ),

        'card'      => array(
            "general"               => "Основное",
            "addImage"              => "Основное изображение",
            "addDocs"               => "Добавить файл (pdf, word, excel)",
            "imageLibrary"          => "Фотогалерея",
            "description"           => "Описание",
            "statusAndVisibility"   => "Статус и видимость",
            "seo"                   => "Seo",
            "brand"                 => "Бренд",
            "rating"                => "Рейтинг товара",
            "advanced"              => "Дополнительно",
            "map"                   => "Карта",
            "providerPaymentSystem" => "Поставщик платежной системы",
        ),
        'tabs'      => array(
            'general'  => 'Основные',
            'summary'  => 'Анонс',
            'content'  => 'Подробнее',
            'misc'     => 'Разное',
            'gallery'  => 'Галерея',
            'seo'      => 'Seo',
            'advanced' => 'Дополнительно',
            'short'    => 'Короткое описание',
            'full'     => 'Полное описание',

        ),
        'misc'      => array(
            'featured'      => 'Избранная',
            'publishDate'   => 'Дата публикации',
            'publishEnd'    => 'Дата завершения',
            'comments'      => 'Комментарии',
        ),
        'fields' => array (
            'name'           => 'Имя',
            'title'          => 'Заголовок',
            'alias'          => 'Альтернативное имя',
            'nickname'       => 'Псевдоним',
            'sectionType'    => 'Тип',
            'contentType'    => 'Тип контента',
            'parent'         => 'Родительский раздел',
            'na'             => 'Н/Д',
            'section'        => 'Раздел',
            'filename'       => 'URL',
            'notAvailable'   => 'Не доступно',
            'text'           => 'Текст',
            'icon'           => 'Иконка',
            'link'           => 'Ссылка',
            'articul'        => 'Артикул',
            'price'          => 'Цена',
            'oldPrice'       => 'Старая цена',
            'featured'       => 'Избранная',
            'publishDate'    => 'Дата публикации',
            'publishEnd'     => 'Дата завершения',
            'comments'       => 'Комментарии',
        ),
	);

    $L['backup'] = array(
        'title'=>'Backup',
        'makeBackup'=>'Создать резервную копию',
        'makeBackupNote'=>'В резервную копию будут сохранены все файлы, картинки и данные, кроме исходных статистических данных.',
        'makeSetup'=>'Создать установочные файлы',
        'makeSetupNote'=>'Другие необходимые файлы, изображения и данные будут добавлены автоматически.',
        'articlesLabel'=>'data table, images, and files',
        'sectionsLabel'=>'data table',
        'commentsLabel'=>'data table',
        'statsLabel'=>'daily cache data',
        'usersLabelYes'=>'все учетные записи',
        'usersLabelNo'=>'admin/admin (пользователь/пароль)',
        'download'=>'Скачать',
        'restore'=>'Восстановить',
        'restoreFromLocal'=>'Восстановить из локального файла:',
        'restoreFromUpload'=>'Восстановить из загруженного файла:',
        'noFilesToRestore'=>'Нет файлов для восстановления',
        'noFilesToManage'=>'Нет файлов для управления',


        'tabs'=>array(
            'backup'=>'Резервная копия',
            'setup'=>'Установочные файлы',
            'restore'=>'Восстановление',
            'manage'=>'Управление',
        ),
        'messages'=>array(
            'Файл резервной копии "{$fileName}" был успешно создан. Чтобы загрузить его, перейдите на вкладку "Управление".',
            'Установщик был успешно создан. Нажмите на ссылки для загрузки <a href="/admin/backup?action=downloadFile&backup[fileName]=setup.dat">setup.dat</a> и <a href="/admin/backup?action=downloadFile&backup[fileName]=setup.php">setup.php</a> файлов.',
            'Файл "{$fileName}" был удален.',
            'Восстановление завершено.',
        ),
        'errors'=>array(
            'Файл "{$fileName}" не найден.',
            'Не удается удалить файл "{$fileName}".',
        ),
    );

	$L['fileManager'] = array(
		'title'        => 'Файл менеджер',
		'files'        => 'Загрузки',
		'notFiles'     => 'Нет загруженных файлов',
		'back'         => 'Назад',
		'addFolder'    => 'Добавить директорию',
        'renameFolder' => 'Переименовать директорию',
		'uploadFile'   => 'Загрузить файл',
		'upToRoot'     => 'Наверх в корень',
		'upload'       => 'Загрузить',
		'add'          => 'Добавить',
		'folderName'   => 'Имя директории',
		'file'         => 'Файл',
		'size'         => 'Размер',
		'folder'       => 'Папка',
		'directoryNotEmpty' => 'Директория не пуста, проверьте содержимое! <br /> Если не хотите проверять, подтвердите удаление.',

		'messages' => array(
			'Директория создана.',
			'Файл загружен.',
			'Файл удален.',
			'Директория удалена.',
			'Файл сохранен.',
			'Файл(ы) загружен(ы)',
            'Директория переименована.',
            'Вы уверены, что хотите удалить эту директорию и все файлы в ней?',
            'Директория и все файлы в ней удалены.',
            'Файл(ы) удален(ы).',
		),
		'errors' => array(
			'Невозможно сохранить загруженный файл. Возможно, стоит ограничение на создание файлов.',
			'Невозможно создать директорию. Возможно, уже существует или стоит ограничение на создание директорий.',
			'Невозможно удалить файл.',
			'Невозможно удалить директорию. (Директория должна быть пустой и скрипт должен иметь соответствующие права)',
			'Невозможно сохранить файл. Возможно, скрипт не наделен соответствующими правами.',
			'Имя файла/директории может состоять только из следующих: A-Z a-z 0-9 . , - _ ( ).',
			'Имя файла/директории не может начинаться с точки.',
			'Введенное имя файла/директории запрещено.',
			'Доступ к указанному пути запрещен.',
			'Файл не найден.',
            'Невозможно переименовать директорию. Возможно, стоит ограничение на создание директорий.',
            'Нельзя удалить эту директорию',
            'Невозможно удалить файлы.',
            'Загружаемый файл пустой, либо к нему невозможно получить доступ.',
            'Слишком большой размер файла.',
            'Слишком большое файл.',
            'Файл с данным именем уже существует на сервере, измените имя загружаемого файла на другое.',
            'Невозможно загрузить файл на сервер.',
            'Нельзя загружать файлы в корневую директорию, нужно создать новую директорию или выбрать из существующих директорий.',
            'Не поддерживаем формат файла, допустимы только (jpg, jpeg, png, gif, webp).',
            'Загруженный файл превышает параметр upload_max_filesize в php.ini',
            'Изображение превышает максимальную ширину или высоту',
            'Изображение превышает максимальную высоту',
            'Для изображения требуется минимальная ширина или высота',
            'Для изображения требуется минимальная высота',
            'Файл слишком мал',
            'Загруженный файл превышает параметр MAX_FILE_SIZE, указанный в HTML-форме',
            'Файл не удалось загрузить, загружаемый файл превышает параметр «UPLOAD_MAX_FILESIZE» или «POST_MAX_SIZE», проверьте настройки сервера!',
            'Загружаемый файл превышает параметр «UPLOAD_MAX_FILESIZE» или «POST_MAX_SIZE», проверьте настройки сервера!'

		),
	);
	$L['templates'] = array(
		'title'               => 'Редактор шаблона',
		'template'            => 'Шаблон',
		'newTemplate'         => 'Новый шаблон',
		'addTemplate'         => 'Добавить шаблон',
		'editTemplate'        => 'Редактирование шаблона',
		'newTemplateFile'     => 'Создать новый файл',
		'selectTemplate'      => 'Шаблон сайта',
		'select'              => 'Выбрать',
		'fileEditing'         => 'Редактирование файла',
		'templateNewFile'     => 'Введите название шаблона без расширения',
		'messages' => array(
			'Файл сохранен.',
			'Шаблон удален.',
			'Шаблон в порядке. Сохраняем...',
			'Тема изменена...',
			'Новый шаблон создан!',
		),
		'errors' => array(
			'Шаблон не найден или доступ запрещен.',
			'Шаблон НЕ сохранен.',
			'Введите имя файла шаблона.',
			'Шаблон с таким именем файла уже существует. Введите другое имя.',
			'Имя фала может содержать только следующие символы: A-Z a-z 0-9 . , - _ ( ).',
			'Невозможно создать временный файл шаблона.',
			'Файл не сохранен, произошла ошибка, попробуйте позже',
			'Нет прав на запись файла. Установите CHMOD (666)',
		),
	);
	$L['managers'] = array(
		'title'           => 'Менеджеры',
		'fullname'        => 'Полное имя',
		'loginname'       => 'Логин',
		'addUser'         => 'Добавить менеджера',
		'userData'        => 'Редактирование менеджера',
		'avatar'          => 'Фото',
		'userProfile'     => 'Редактирование менеджера',
		'userProfileFoto' => 'Фото менеджера',
		'uploadAvatar'    => 'Загрузить фото',
		'sectionRights'   => 'Доступ к разделам',
		'registration'    => 'Зарегистрирован',
		'email'           => 'Email',
		'phone'           => 'Номер телефона',
		'address'         => 'Адрес',
		'password'        => 'Пароль',
		'newPassword'     => 'Новый пароль',
		'online'          => 'online',
		'offline'         => 'offline',
		'activity'        => 'Последняя активность',
		'accessLevel'     => 'Роль менеджера',
        'adding'          => 'Добавление нового менеджера',
        'editing'         => 'Редактирование менеджера',
        'verifiedState'   => 'Подтвердить email',
        'statuses' => array(
            '0' => 'Выбрать статус',
            '1' => 'Активен',
            '2' => 'Заблокирован',
            '3' => 'Ожидает подтверждения',
        ),
		'verified' => array(
		    '0' => 'Email не подтвержден',
            '1' => 'Email подтвержден',
        ),
		'accessControl' => 'Контроль доступа',
		'accessControlOptions' => array(
			'allowAll'      => 'Разрешить доступ ко всем разделам',
			'allowSelected' => 'Разрешить доступ только к <span class="text-danger">выбранным разделам</span>',
		),
		'section'      => 'Раздел',
		'noSections'   => 'Нет разделов',
		'checkUncheck' => 'Отметить все/снять отметку со всех',
		'allChild'     => 'и все подразделы',

		'messages' => array(
			'Менеджер сохранен.',
			'Менеджер удален.',
			'Картинка удалена.',
			'Изменения сохранены.',
		),
		'errors' => array(
			'Указанное имя менеджера уже существует.',
			'Менеджер не найден.',
			'Введите логин. (только цифры и латинские буквы)',
			'Введите имя и фамилию менеджера.',
			'Введите пароль.',
			'Менеджер НЕ сохранен:',
			'Невозможно удалить или изменить уровень доступа менеджера, т.к. остался всего один менеджер с правами администратора.',
			'Остался всего один Менеджер!',
			'Картинка не добавлена',
			'У Вас нет прав получить статус разработчика',
			'Невозможно удалить или изменить уровень доступа разработчика, т.к. остался всего один разработчик для техподдержки.',
            'Необходимо дать права доступа хотя бы к одному пункту',
            'Необходимо указать правильный и действующий email',
            'Поле логин не должно быть пустым',
            'Невозможно удалить или изменить уровень доступа менеджера, т.к. остался всего один менеджер с правами разработчика.',
            'Менеджер не удален.',
            'Менеджеру необходимо назначить группу .',
		),
	);

    $L['brands'] = array(
        'title'=>'Бренд',
        'messages'=>array(
            'Бренд &laquo;{$brand.name}&raquo; сохранен.',
            'Картинка удалена.',
            'Бренд удален.',
            'Бренд опубликован.',
        ),
        'errors'=>array(
            'Доступ запрещен.',
            'Введите заголовок.',
            'Выберите раздел.',
            'Бренд &laquo;{if isset($brand.name)}{$brand.name}{/if}&raquo; НЕ сохранен.',
            'Перед добавлением бренд, добавьте хотя бы один раздел.',
            'Картинка НЕ сохранена.',
            'Бренд не найдена или доступ запрещен.',
            'Введите URL.',
            'Бренд с таким URL уже существует. Введите другой URL.',
            'Такое имя файла запрещено.',
            'URL может состоять только из следующих символов: A-Z a-z 0-9 . , - _',
            'Бренд НЕ удален',
        ),
    );

	$L['articles'] = array(
		'title' => 'Контент',
        'misc'  =>  array(
            'featured'      => 'Избранная',
            'publishDate'   => 'Дата публикации',
        ),
		'messages' => array(
			'Контент &laquo;{$article.title}&raquo; сохранен.',
			'Картинка удалена.',
			'Контент удален.',
			'Контент опубликован.',
		),
		'errors' => array(
			'Доступ запрещен.',
			'Введите заголовок.',
			'Выберите раздел.',
			'Контент &laquo;{if isset($article.title)}{$article.title}{/if}&raquo; НЕ сохранен.',
			'Перед добавлением контент, добавьте хотя бы один раздел.',
			'Картинка НЕ сохранена.',
			'Контент не найден или доступ запрещен.',
			'Введите URL.',
			'Контент с таким URL уже существует. Введите другой URL.',
			'Такое имя файла запрещено.',
			'URL может состоять только из следующих символов: A-Z a-z 0-9 . , - _',
			'Контент НЕ удален',
		),
	);

    $L['models'] = array(
        'title' => 'Модель',
        'misc'  =>  array(
            'featured'      => 'Избранная',
            'publishDate'   => 'Дата публикации',
        ),
        'messages' => array(
            'Контент &laquo;{$model.title}&raquo; сохранен.',
            'Картинка удалена.',
            'Контент удален.',
            'Контент опубликован.',
        ),
        'errors' => array(
            'Доступ запрещен.',
            'Введите заголовок.',
            'Выберите раздел.',
            'Контент &laquo;{if isset($model.title)}{$model.title}{/if}&raquo; НЕ сохранен.',
            'Перед добавлением контент, добавьте хотя бы один раздел.',
            'Картинка НЕ сохранена.',
            'Контент не найден или доступ запрещен.',
            'Введите URL.',
            'Контент с таким URL уже существует. Введите другой URL.',
            'Такое имя файла запрещено.',
            'URL может состоять только из следующих символов: A-Z a-z 0-9 . , - _',
            'Контент НЕ удален',
        ),
    );

    $L['projects'] = array(
        'title' => 'Проекты',
        'misc'  =>  array(
            'featured'      => 'Избранная',
            'publishDate'   => 'Дата публикации',
        ),
        'messages' => array(
            'Проект &laquo;{$project.title}&raquo; сохранен.',
            'Картинка удалена.',
            'Проект удален.',
            'Проект опубликован.',
        ),
        'errors' => array(
            'Доступ запрещен.',
            'Введите заголовок.',
            'Выберите раздел.',
            'Проект &laquo;{if isset($project.$project)}{$project.title}{/if}&raquo; НЕ сохранен.',
            'Перед добавлением проекта, добавьте хотя бы один раздел.',
            'Картинка НЕ сохранена.',
            'Проект не найден или доступ запрещен.',
            'Введите URL.',
            'Проект с таким URL уже существует. Введите другой URL.',
            'Такое имя файла запрещено.',
            'URL может состоять только из следующих символов: A-Z a-z 0-9 . , - _',
            'Проект НЕ удален',
        ),
    );

    $L['categorys'] = array(
        'title'=>'Каталог',
        'workingHours'=>'Время работы',
        'phone'=>'Телефон',
        'site'=>'Сайт',
        'address'=>'Адрес',
        'coordinates'=>'Координаты (lat, long)',
        'discountprice'=>'Цена со скидкой',
        'addObject'=>'Добавить новый объект',
        'showAllProducts'=>'Показать все объекты',
        'featuredProduct'=>'Избранный объект',
        'approve'=>'Одобрить',
        'allSections'=>'Все разделы',
        'myProducts'=>'Мои объекты',
        'attachment'=>'Прикрепленный файл',
        'attachmentView'=>'Скачать прикрепленный файл',
        'deleteAttachment'=>'Удалить прикрепленный файл',
        'short'=>'Короткое описание',
        'full'=>'Полное описание',
        'uploadedImages'=>'Загруженные изображения',
        'addText'=>'Добавьте текст к картинке',
        'selectFile'=>'Выберите файл',
        'download'=>'Загрузить',
        'fileDescription'=>'Описание',
        'noImagesUploaded'=>'Нет загруженные изображения',
        'imageDescription'=>'например название картинки',
        'image'=>'Картинка',
        'favorites'=>'Избраное',
        'images'=>' Изображения товара',
        'addImage'=>'Добавить изображение',
        'statusProduct'=>'Статус объекта',
        'allStatusProduct'=>'Все статусы продукции',
        'allProduct'=>'Все объекты',
        'foto'=>'Фотогалерея',
        'imageDownload'=>'<p style="color: green; text-align: center; margin: 20px 0;">Изображение успешно загружено!</p>',
        'imageNotDownload'=>'<p style="color: red; text-align: center; margin: 20px 0;">Изображение не может загружено!<br>Попробуйте позже!</p>',
        'productTags'=>'<label class="field_name">Теги продукта</label>',
        'datePublicationEnd'=>'Дата окончания публикации объекта на сайте',
        'startPublication'=>'Дата начала публикации объекта на сайте',
        'showSite'=>'Показать или не показывать на страницах сайта',
        'addressStore'=>'Если имеется объект в наличии в каком то магазине - укажите адрес магазина',
        'publicationWebsite'=>'Порядок публикации на сайте',
        'specifySectionProduct'=>'Необходимо указать к какому разделу относится объект',
        'discountExpressedPercentage'=>'Скидка, указывается в процентах (%)',
        'availabilityGoods'=>'Наличие объекта на складе или в магазине',
        'doYouProvideDelivery'=>'Предоставляете ли вы доставку объекта',
        'specifyManufacturerStore'=>'Укажите производителя - если объект не принадлежат вам',
        'deletePicture'=>'Вы действительно хотите удалить изображение?',
        'status'=>'Cтатус',
        'orderBy'=>'Сортировка',
        'statuses'=>array(
            '0' => 'Все статусы',
            'V' => 'Включено',
            'H' => 'Скрыто',
            'P' => 'В ожидании',
        ),

        'stockstatuses'=>array(
            '0'=>'Статус продукта',
            'available'=>'В наличие',
            'notavailable'=>'Нет в наличии',
            'expectation'=>'Ожидание 2-3 дня',
            'preorder'=>'Предзаказ',
        ),

        'deliverys'=>array(
            ''=>'Статус доставки',
            'no'=>'Нет',
            'yes'=>'Да',
        ),

        'tabs'=>array(
            'general'=>'Основные',
            'summary'=>'Анонс',
            'content'=>'Описание',
            'services'=>'Услуги',
            'misc'=>'Разное',
            'gallery'=>'Галерея',
            'seo'=>'Seo',
            'address'=>'Адрес и координаты объекта',
        ),
        'general'=>array(
            'title'=>'Название объекта',
            'section'=>'Раздел',
            'filename'=>'URL',
            'alias'=>'Подзаголовок объекта',
            'location'=>'Расположение',
            'manufacturer'=>'Производитель',
            'stockstatus'=>'Наличие продукта',
            'delivery'=>'Доставка объекта',

            'notAvailable'=>'Не доступно',
            'primaryImage'=>'Изображение объекта',
            'originalImage'=>'Исходная картинка',
            'mediumThumbnail'=>'Средняя картинка',
            'largeThumbnail'=>'Большая картинка',
            'deleteThumbnails'=>'Удалить картинки',
            'replaceImage'=>'Заменить картинку',
            'searchByName'=>'Поиск по названию',
            'searchByBrand'=>'Поиск по производителю',
            'searchByPrice'=>'Поиск по цене',
            'filterByDestination'=>'Фильтровать по направлению',
            'filterByStatusLabel'=>'Фильтровать по ярлыку объекта',
            'filterByStatusSstock'=>'Фильтровать по статусу объекта в наличии',
        ),
        'misc'=>array(
            'featured'=>'Избранная',
            'publishDate'=>'Дата публикации',
            'publishEnd'=>'Дата завершения',
            'comments'=>'Комментарии',
        ),

        'messages'=>array(
            'Объект &laquo;{$article.title}&raquo; сохранен.',
            'Картинка удалена.',
            'Объект удален.',
            'Объект опубликован.',
        ),
        'errors'=>array(
            'Доступ запрещен.',
            'Введите название объекта.',
            'Выберите раздел.',
            'Объект &laquo;{$article.title}&raquo; НЕ сохранен.',
            'Перед добавлением объекта, добавьте хотя бы один раздел.',
            'Картинка НЕ сохранена.',
            'Объект не найдена или доступ запрещен.',
            'Введите URL.',
            'Объект с таким URL уже существует. Введите другое имя.',
            'Невозможно сохранить файл .htaccess.',
            'Невозможно сохранить сериальный файл.',
            'Такое имя файла запрещено.',
            'URL может состоять только из следующих символов: A-Z a-z 0-9 . , - _',
        ),
    );

	$L['products'] = array(
		'title'=>'Продукция',
		'articul'=>'Артикул',
		'sale'=>'Скидка в %',
		'discountprice'=>'Цена со скидкой',
		'oldPrice'=>'Старая цена',
		'price'=>'Цена',
		'stock'=>'Кол-во',
		'approve'=>'Одобрить',
		'allSections'=>'Все разделы',
		'myProducts'=>'Моя продукция',
		'attachment'=>'Прикрепленный файл',
		'attachmentView'=>'Скачать прикрепленный файл',
		'deleteAttachment'=>'Удалить прикрепленный файл',
		'short'=>'Короткое описание',
		'full'=>'Полное описание',
		'uploadedImages'=>'Загруженные изображения',
		'addText'=>'Добавьте текст к картинке',
		'selectFile'=>'Выберите файл',
		'download'=>'Загрузить',
		'fileDescription'=>'Описание',
		'noImagesUploaded'=>'Нет загруженные изображения',
		'imageDescription'=>'например название картинки',
		'image'=>'Картинка',
		'favorites'=>'Избраное',
		'images'=>' Изображения товара',
		'addImage'=>'Добавить изображение',
		'statusProduct'=>'Статус продукта',
		'allStatusProduct'=>'Все статусы продукции',
		'allProduct'=>'Вся продукция',
		'foto'=>'Фотогалерея',
		'imageDownload'=>'<span class="text-center text-success my-2">Изображение успешно загружено!</span>',
		'imageNotDownload'=>'<span class="text-center text-danger my-2">Изображение не может загружено!<br>Попробуйте позже!</span>',
		'productTags'=> 'Теги продукта',
		'datePublicationEnd'=>'Дата окончания публикации продукта на сайте',
		'startPublication'=>'Дата начала публикации продукта на сайте',
		'showSite'=>'Показать или не показывать на страницах сайта',
		'addressStore'=>'Если имеется продукт в наличии в каком то магазине - укажите адрес магазина',
		'publicationWebsite'=>'Порядок публикации на сайте',
		'specifySectionProduct'=>'Необходимо указать к какому разделу относится продукт',
		'discountExpressedPercentage'=>'Скидка, указывается в процентах (%)',
		'availabilityGoods'=>'Наличие продукта на складе или в магазине',
		'doYouProvideDelivery'=>'Предоставляете ли вы доставку продукта',
		'specifyManufacturerStore'=>'Укажите производителя - если продукт или продукт не принадлежат вам',
		'deletePicture'=>'Вы действительно хотите удалить изображение?',
		'orderBy'=>'Сортировка',
		'stockstatuses'=>array(
			'0'=>'Статус продукта',
			'available'=>'В наличие',
			'notavailable'=>'Нет в наличии',
			'expectation'=>'Ожидание 2-3 дня',
			'preorder'=>'Предзаказ',
		),
		
		'deliverys'=>array(
			''=>'Статус доставки',
			'no'=>'Нет',
			'yes'=>'Да',
		),

		'general'=>array(
			'title'=>'Название продукта',
			'section'=>'Раздел',
			'filename'=>'URL',
			'alias'=>'Подзаголовок продукта',
			'location'=>'Расположение',
			'manufacturer'=>'Производитель',
			'stockstatus'=>'Наличие продукта',
			'delivery'=>'Доставка продукта',
			
			'notAvailable'=>'Не доступно',
			'primaryImage'=>'Изображение продукта',
			'originalImage'=>'Исходная картинка',
			'mediumThumbnail'=>'Средняя картинка',
			'largeThumbnail'=>'Большая картинка',
			'deleteThumbnails'=>'Удалить картинки',
			'replaceImage'=>'Заменить картинку',
			'searchByName'=>'Поиск по названию',
			'searchByBrand'=>'Поиск по производителю',
			'searchByPrice'=>'Поиск по цене',
			'filterByDestination'=>'Фильтровать по направлению',
			'filterByStatusLabel'=>'Фильтровать по ярлыку продукта',
			'filterByStatusSstock'=>'Фильтровать по статусу продукта в наличии',
		),
		'messages'=>array(
			'Продукт &laquo;{$product.title}&raquo; сохранен.',
			'Картинка удалена.',
			'Продукт удален.',
			'Продукт опубликован.',
		),
		'errors'=>array(
			'Доступ запрещен.',
			'Введите название продукта.',
			'Выберите раздел.',
			'Продукт &laquo;{$product.title}&raquo; НЕ сохранен.',
			'Перед добавлением продукта, добавьте хотя бы один раздел.',
			'Картинка НЕ сохранена.',
			'Продукт не найдена или доступ запрещен.',
			'Введите URL.',
			'Продукт с таким URL уже существует. Введите другое имя.',
			'Невозможно сохранить файл .htaccess.',
			'Невозможно сохранить сериальный файл.',
			'Такое имя файла запрещено.',
			'URL может состоять только из следующих символов: A-Z a-z 0-9 . , - _',
		),
	);

	$L['sections'] = array(
		'title'=>'Разделы',
		'upToRoot'=>'Наверх в корень',
		'upTo'=>'Наверх к',
		'moveToRoot'=>'Переместить в: Корень (верхний уровень)',
		'moveTo'=>'Переместить в',
		'deleting'=>'Удаляется раздел',
		'subsectionsAndArticles'=>'Подразделы и их контент',
		'deleteSectionQuestion'=>'Вы уверены, что хотите удалить раздел {if isset($section.hasSubsections) || isset($section.hasArticles)}и выполнить выбранные действия{/if}',
		'noSubsections'=>'Этот раздел не содержит подразделов. Перемещаем наверх...',
		'noImages'=>'Нет загруженных фотографий',
		'imageList'=>'Список загруженных изображений',
		'primaryImage'=>'Основная картинка',
		'selectFile'=>'Выберите файл',
		'text'=>'Текст',
		'delete'=>'Удаление раздела',
		'file'=>'Файл',
		'sectionType'=>'Тип',
		'contentType'=>'Тип контента',
		'settingSection'=>'Настройки раздела',
		'icon'=>'Иконка раздела',
		'mainSections'=>'Главное меню',
		'otherSections'=>'Структура сайта',
		'mainMenu'=>'Отображать в главном меню сайта',
		'footerMenu'=>'Отображать в нижнем меню сайта',
		'hiddenMainMenu'=>'Скрыть подразделы в главном меню ',
		'photoGallery'=>'Фотогалерея в этом разделе',
        'iconSection'=>'Иконка в этом разделе',
		'funcDevelopers'=>'Скрыть от пользователя',
		'uploadedImages'=>'Загруженные картинки',
		'addToGallery'=>'Добавьте картинки',
		'status'=>'Статус',
		'statuses'=>array(
			'V'=>'Включен',
			'H'=>'Скрыт',
		),
		'types'=>array(
            'tree'  => 'Раздел',
			'plain' => 'Страница'
		),
		'typeContents'  => array(
            'articles'  => 'Контент',
            'projects'  => 'Проекты',
            'brand'     => 'Бренд',
            'products'  => 'Продукция',
            'news'      => 'Новости',
            'partners'  => 'Партнеры',
            'vacancys'  => 'Вакансии',
            'reviews'   => 'Отзывы',
            'faq'       => 'FAQ',
            'block'     => 'Блок',
//            'gallerys'  => 'Галерея',
		),
		'tabs'=>array(
			'general'=>'Основное',
			'advanced'=>'Дополнительно',
			'misc'=>'Seo',
			'images'=>'Фотогалерея',
			'summary'=>'Анонс',
			'content'=>'Подробнее',
		),
		'general'=>array(
  		    'name'=>'Имя',
			'parent'=>'Родительский раздел',
			'na'=>'Н/Д',
			'filename'=>'URL',
			'alias'=>'Альтернативное имя',
		),
		'messages'=>array(
			'Раздел «{$section.name}» сохранен.',
			'Раздел «{$section.name}» удален.',
			'Разделы отсортированы.',
			'Раздел перемещен вверх.',
			'Раздел перемещен вниз.',
			'Картинка удалена.',
			'Раздел добавлен в главное меню.',
			'Раздел удален из главного меню.',
			'Раздел виден.',
			'Раздел скрыт.',
			'Картинка успешно загружена',
		),
		'errors'=>array(
			'Раздел «{$section.name}» НЕ сохранен.',
			'Раздел не найден.',
			'Введите название раздела.',
			'Введите URL раздела.',
			'Раздел с таким URL уже существует.',
			'Невозможно сохранить файл .htaccess.',
			'Невозможно сохранить сериальный файл.',
			'Такое URL запрещен.',
			'URL может состоять только из следующих символов: A-Z a-z 0-9 . , - _',
			'Невозможно сохранить сериальный файл.',
			'Раздел не может быть перемещен выше.',
			'Раздел не может быть перемещен ниже.',
			'Произошла ошибка попробуйте обновить страницу и повторить действие.',
			'Невозможно поменять тип. За разделом закреплены подразделы или контент.',
			'Картинка не удалена.',
			'Тип контента не соответствует основному разделу.',
			'Раздел не может быть страницей!',
            'Страница с таким URL уже существует.',
		),
	);

    $L['sliders'] = array(
        'title'=>'Слайдер',
        'alias'=>'Подзаголовок',
        'text'=>'Дополнительное поле для текста',
        'links'=>'Ссылка',
        'addSlider'=>'Добавить Слайд',
        'showAllSliders'=>'Показать все Слайды',
        'featuredSlider'=>'Избранные Слайды',
        'short'=>'Небольшое описание',
        'full'=>'Полное описание',
        'uploadedImages'=>'Загруженные изображения',
        'addText'=>'Добавьте текст к картинке',
        'selectFile'=>'Выберите файл',
        'download'=>'Загрузить',
        'fileDescription'=>'Описание',
        'noImagesUploaded'=>'Нет загруженные изображения',
        'imageDescription'=>'например название картинки',
        'image'=>'Картинка',
        'favorites'=>'Избраное',
        ''=>'',
        'statuses'=>array(
            '0'=>'Все статусы',
            'V'=>'Включен',
            'H'=>'Скрыт',
        ),

        'tabs'=>array(
            'general'=>'Основное',
            'summary'=>'Небольшое описание',
            'misc'=>'Разное',
        ),
        'general'=>array(
            'orderBy'=>'Сортировка',
            'title'=>'Заголовок',
            'status'=>'Статус',
            'filename'=>'URL',
            'notAvailable'=>'Не доступно',
            'primaryImage'=>'Основная картинка',
            'originalImage'=>'Исходная картинка',
            'mediumThumbnail'=>'Средняя картинка',
            'largeThumbnail'=>'Большая картинка',
            'deleteThumbnails'=>'Удалить картинки',
            'replaceImage'=>'Заменить картинку',
        ),
        'misc'=>array(
            'publishDate'=>'Дата публикации',
        ),

        'messages'=>array(
            'Слайд &laquo;{$banner.title}&raquo; сохранен.',
            'Картинка удалена.',
            'Слайд удален.',
            'Слайд опубликован.',
        ),
        'errors'=>array(
            'Доступ запрещен.',
            'Введите заголовок.',
            'Выберите раздел.',
            'Слайд &laquo;{$banner.title}&raquo; НЕ сохранен.',
            'Перед добавлением слайда, добавьте хотя бы один раздел.',
            'Картинка НЕ сохранена.',
            'Слайд не найден или доступ запрещен.',
            'Введите имя файла.',
            'Слайд с таким URL уже существует. Введите другой URL.',
            'Невозможно сохранить файл .htaccess.',
            'Невозможно сохранить сериальный файл.',
            'Такое имя файла запрещено.',
            'URL может состоять только из следующих символов: A-Z a-z 0-9 . , - _',
            'Картинка не удалена',
        ),
    );

    $L['comments'] = array(
        'title'=>'Комментарии',
        'comment'=>'Комментарий',
        'authorName'=>'Имя автора',
        'authorEmail'=>'Email автора',
        'status'=>'Статус',
        'commentMessage'=>'Комментарий',
        'commentAnswer'=>'Ваш ответ на данный комментарий',
        'website'=>'Вебсайт',
        'showAllComments'=>'Показать все комментарии',
        'ip'=>'IP',
        'spam'=>'СПАМ',
        'approve'=>'Одобрить',
        'skip'=>'Игнорировать',
        'markComments'=>'Отметить все комментарии',
        'approval'=>'Одобрить',
        'deletion'=>'Удалить',
        'later'=>'Отложить',
        'saveChanges'=>'Сохранить изменения',
        'new'=>'новых',
        'news'=>'Новые коментарии',
        'statuses'=>array(
            '0'         => 'Все статусы',
            'pending'   => 'Ожидает',
            'approved'  => 'Одобрен',
            'spam'      => 'СПАМ'
        ),
        'messages'=>array(
            'Комментарий сохранен.',
            'Изменения сохранены.',
            'Комментарий удален.',
        ),
        'errors'=>array(
            'Доступ запрещен.',
            'Комментарий НЕ сохранен.',
            'Комментарий не найден или доступ запрещен.',
            'Отсутствует емайл.',
            'Отсутствует имя автора.',
            'Отсутствует комментарий.',
            'Не верно указан емайл.',
        ),
    );

	$L['javascript'] = array(
		'operationError'=>'Операция завершена с ошибкой. Страница будет перезагружена. Ответ сервера:',
		'processingRequest'=>'Обрабатывается другой запрос. Попробуйте повторить запрос позже.',
		'movingDown'=>'Перемещаем вниз',
		'movingUp'=>'Перемещаем вверх',
		'sureToChangeLang'=>'Вы уверены, что хотите изменить основной язык сайта на',
		'sureToDelete'=>'Вы уверены, что хотите удалить',
		'sureToDeleteOrderStatus'=>'Вы уверены, что хотите удалить статус',
		'sureToDeleteImage'=>'Вы уверены, что хотите удалить картинку',
		'surToDeleteImage'=>'Вы уверены, что хотите удалить изображение?',
		'sureToDeleteStats'=>'Вы уверены, что хотите удалить статистические данные до',
		'deletingImage'=>'Картинка удалена',
        'deletingImageError'=>'Картинка не удалена, произошла ошибка',
        'deletingDocs'=>'Файл удален',
        'deletingDocsError'=>'Файл не удален, произошла ошибка',
		'deletingSecImage'=>'картинка удалится после сохранения',
		'deletingUser'=>'Пользователь удаляется',
		'deletingArticle'=>'Статья удаляется',
		'deletingMail'=>'Письмо удаляется',
		'deletingOrderStatus'=>'Статус заказа удаляется',
		'sureToDeleteLabel'=>'Вы уверены, что хотите удалить',
		'deletingLabel'=>'Удаляется',
		'deletingTemplate'=>'Шаблон удаляется',
		'deletingCss'=>'Стили удаляются',
		'changingStatus'=>'Изменяется статус',
		'smartyErrorOnLine'=>'Smarty: ошибка на строке',
		'testingTemplate'=>'Шаблон тестируется',
		'search'=>'Искать',
		'clearingCache'=>'Очищается кэш',
		'clearingStats'=>'Очищаются статистические данные, пожалуйста подождите',
		'changeDefaultLang'=>'Изменить основной язык',
		'demoMode'=>'В демонстрационном режиме эта функция заблокирована.',
        'dictDefaultMessage'            => 'Перетащите файлы для загрузки в это поле',
        'dictFallbackMessage'           => 'К сожалению, ваш браузер не поддерживает',
        'dictFallbackText'              => 'Пожалуйста, воспользуйтесь старой доброй формой для загрузки',
        'dictFileTooBig'                => 'Файл слишком большой({{filesize}}MB). Максимальный допустимый размер файла {{maxFilesize}}MB',
        'dictInvalidFileType'           => 'Вы не можете загружать файлы этого типа.',
        'dictResponseError'             => 'Произошла ошибка при загрузке файла. Попробуйте еще раз. Если ошибка будет повторяться - передайте эту информацию администратору сайта: Код ошибки {{statusCode}}',
        'dictCancelUpload'              => 'Отменить',
        'dictCancelUploadConfirmation'  => 'Уверены, что хотите прервать загрузку?',
        'dictRemoveFile'                => 'Удалить',
        'dictRemoveFileConfirmation'    => '',
        'dictMaxFilesExceeded'          => 'Превышен лимит количества файлов. Вы можете загрузить не более {{maxFiles}}',
	);

	$L['languages'] = array(
		'title'=>'Языки сайта',
		'add'=>'Добавить язык',
		'language'=>'Язык',
		'languageDesc'=>'латинскими буквами, например: Russian, English, German, French',
		'general'=>'Основное',
		'codename'=>'Код языка',
		'codenameDesc'=>'2 латинские буквы, например: ru, en, de, fr',
		'predefinedLanguages'=>'Предустановленные языки',
		'status'=>'АКТИВНОСТЬ',
		'flag'=>'ФЛАГ',
		'multilangMode'=>'Мультиязычный режим',
		'toMultilangModeDesc'=>'Для переключения в мультиязычный режим введите информацию о языке, который сейчас используется на вашем сайте.',
		'default'=>'По умолчанию',
		'delete'=>'Удалить языковую версию сайта',
		'deleteDesc'=>'При удалении языковой версии сайта так же будут удалены все картинки, файлы и таблицы с данными для этого языка.',
		'confirmDelete'=>'Подтвердите ваше намерение удалить языковую версию сайта',
		'setAsDefault'=>'Сделать основным',
		'changeDefaultLang'=>'Изменить основной язык',

		'messages'=>array(
			'Язык сохранен.',
			'Язык удален.',
			'Язык перемещен.',
			'Язык перемещен вниз.',
			'Язык удален.',
            'Действия с языком сайта успешно выполнены.',
		),
		'errors'=>array(
			'«{$language.languageName}» язык не сохранен.',
			'Язык не найден.',
			'Введите название языка.',
			'Введите кодовое обозначение языка.',
			'Язык с таким кодовым обозначением уже существует.',
			'Невозможно сохранить файл ".htaccess".',
			'Невозможно сохранить сериализационный файл.',
			'Кодовое обозначение языка может содержать только строчные латинские буквы от a до z.',
			'Язык не может быть перемещен.',
			'Название языка может содержать только латинские буквы от A до z.',
            'Действия с языком сайта не успешно выполнены.',
		),
		'statuses'=>array(
			'V' => 'Включен',
			'H'  => 'Выключен',
		),

	);

    $L['payments'] = array(
        'title'           => 'Способы оплаты',
        'name'            => 'Название',
        'messages' => array(
            'payment_save'   => 'Способ оплаты «{if isset($payment->name)}{$payment->name}{/if}» сохранен.',
            'payment_delete' => 'Способ оплаты удален.',
        ),
        'errors' => array(
            'access_denied'      => 'Доступ запрещен.',
            'name'               => 'Введите название.',
            'fileNameExists'     => 'Выбранная платежная система уже добавлена',
            'not_saved'          => 'Способ оплаты «{if isset($payment.name)}{$payment.name}{/if}» НЕ сохранен.',
            'payment_not_found'  => 'Способ оплаты НЕ найден',
            'payment_not_delete' => 'Способ оплаты НЕ удален',
        ),
    );

    $L['translations'] = array(
        'name'      => 'Переводы для сайта',
        'variable'  => 'Переменная',
        'transfer'  => 'Перевод',
        'messages' => array(
            'Переменная сохранена.',
            'Переменная удалена.',
        ),
        'errors' => array(
            'Переменная НЕ сохранена.',
            'Переменная НЕ удалена.',
        ),
    );

	$L['dates'] = array(

		'January'   => 'Январь',
		'February'  => 'Февраль',
		'March'     => 'Март',
		'April'     => 'Апрель',
		'May'       => 'Май',
		'June'      => 'Июнь',
		'July'      => 'Июль',
		'August'    => 'Август',
		'September' => 'Сентябрь',
		'October'   => 'Октябрь',
		'November'  => 'Ноябрь',
		'December'  => 'Декабрь',

		'Jan' => 'Янв',
		'Feb' => 'Фев',
		'Mar' => 'Мар',
		'Apr' => 'Апр',
		'May' => 'Май',
		'Jun' => 'Июн',
		'Jul' => 'Июл',
		'Aug' => 'Авг',
		'Sep' => 'Сен',
		'Oct' => 'Окт',
		'Nov' => 'Ноя',
		'Dec' => 'Дек',

		'Sunday'    => 'Воскресенье',
		'Monday'    => 'Понедельник',
		'Tuesday'   => 'Вторник',
		'Wednesday' => 'Среда',
		'Thursday'  => 'Четверг',
		'Friday'    => 'Пятница',
		'Saturday'  => 'Суббота',

		'Sun' => 'Вс',
		'Mon' => 'Пн',
		'Tue' => 'Вт',
		'Wed' => 'Ср',
		'Thu' => 'Чт',
		'Fri' => 'Пт',
		'Sat' => 'Сб',
	);

	$L['visitTypes'] = array(
		1=>'Главная',
		2=>'Страница',
		3=>'Контент',
		4=>'Поиск',
		5=>'Клик',
		6=>'Ошибка',
		//7=>'RSS',
	);

	$L['languageList'] = array(
		'ab'=>'Абхазский',
		'az'=>'Азербайджанский',
		'en'=>'Английский',
		'ar'=>'Арабский',
		'hy'=>'Армянский',
		'eu'=>'Басков',
		'be'=>'Беларусский',
		'bn'=>'Бенгальский',
		'bs'=>'Боснийский',
		'bg'=>'Болгарский',
		'hu'=>'Венгерский',
		'vi'=>'Вьетнамский',
		'nl'=>'Голландский',
		'el'=>'Греческий',
		'ka'=>'Грузинский',
		'da'=>'Датский',
		'he'=>'Иврит',
		'id'=>'Индонезийский',
		'ga'=>'Ирландский',
		'es'=>'Испанский',
		'it'=>'Итальянский',
		'ca'=>'Каталонский',
		'zh'=>'Китайский',
		'kk'=>'Казахский',
		'ky'=>'Киргизский',
		'ko'=>'Корейский',
		'ku'=>'Курдский',
		'lv'=>'Латвийский',
		'la'=>'Латинский',
		'lt'=>'Литовский',
		'mk'=>'Македонский',
		'ms'=>'Малайский',
		'mo'=>'Молдавский',
		'mn'=>'Монгольский',
		'no'=>'Норвежский',
		'de'=>'Немецкий',
		'os'=>'Осетинский',
		'fa'=>'Персидский',
		'pl'=>'Польский',
		'pt'=>'Португальский',
		'ro'=>'Румынский',
		'ru'=>'Русский',
		'sa'=>'Санскрит',
		'sr'=>'Сербский',
		'sk'=>'Словакский',
		'sl'=>'Словенский',
		'tg'=>'Таджикский',
		'tt'=>'Татарский',
		'th'=>'Тайский',
		'tr'=>'Турецкий',
		'tk'=>'Туркменский',
		'ug'=>'Уйгурский',
		'ua'=>'Украинский',
		'uz'=>'Узбекский',
		'fo'=>'Фарерский',
		'fi'=>'Финский',
		'fr'=>'Французский',
		'hi'=>'Хинди',
		'hr'=>'Хорватский',
		'cs'=>'Чешский',
		'sv'=>'Шведский',
		'eo'=>'Эсперанто',
		'et'=>'Эстонский',
		'ja'=>'Японский',
	);
    
    $L['charts'] = array(
		'title' => 'Чарты',
        'addChart'=> 'Добавить чарт',
        'chartName'=> 'Чарт',
        'chartType'=> 'Тип Чарта',
        'content'=> 'Описание чарта',
        'value1'=> 'Данные 1',
        'value2'=> 'Данные 2',
        'addRow'=> 'Добавить строку',
        'removeRow' => 'Удалить строку',
        'confirmDelete' => 'Вы действительно хотите удалить Чарт :',
        'deleted' => 'Чарт удален',
        'saved' => 'Чарт сохранен',
        'tabs' => array(
            'general'=>'Общее',
            'content'=>'Контент',
            'inputData'=>'Входные данные'
        ),
        'types' => array(
            'line'=>'Линия',
            'bar'=>'Бар'
        ),
	);

	$L['banners'] = array(
		'title'=>'Рекламные баннеры',
		'tableTitle'=>'Заголовок баннер', 
		'sectionName'=>'Управление рекламными баннерами', 
		'new'=>'Добавить баннер', 
		'bannerName'=>'Баннер',
		'noBanners'=>'Нет баннеров', 
		'isActive'=>'Баннер активен',
		'bannerUrl'=>'URL для нажатия',
		'file'=>'Файл баннер', 
		'alternativeText'=>'Альтернативный текст',
		'general'=>'Общие', 
		'bannerFile'=>'Баннер файл', 
		'confirmDelete'=>'Вы действительно хотите удалить баннер', 
		'deleted'=>'Баннер удален', 
		'saved'=>'Баннер сохранен', 
		'errorFileType'=>'Неверный тип файла баннера', 
		'directCode'=>'Прямой код', 
		'frameCode'=>'Код через iframe', 
		'listBanners'=>'Список баннеров', 
		'generateCode'=>'Сгенерировать код', 
		'selectFile'=>'Выберите файл',
		'messages'=>array(
			'Баннер сохранен.',
			'Баннер удален.',
		),
		'errors'=>array(
			'Баннер не сохранен',
			'Доступ запрещен',
			'Введите название банера'
		),
	);
	
	$L['users'] = array(
		'title'         => 'Пользователи',
		'editProfile'   => 'Редактировать пользователя',
        'statuses' => array(
            '0' => 'Выбрать статус',
            '1' => 'Активен',
            '2' => 'Заблокирован',
            '3' => 'Ожидает подтверждения',
        ),
        'genders'=>array(
            '0' => 'Выберите пол',
            '1' => 'Муж',
            '2' => 'Жен',
        ),
        'subscribes' => array(
			'yes' => 'Подписан',
			'no'  => 'Не подписан'
		),
		'table' => array(
			'id'        => 'ID',
			'date'      => 'ДАТА',
			'login'     => 'ЛОГИН',
            'email'     => 'EMAIL',
            'phone'     => 'ТЕЛЕФОН',
			'status'    => 'СТАТУС',
			'action'    => 'ДЕЙСТВИЕ',
		),
		'general' => array(
			'gender'    => 'Пол',
			'avatar'    =>'Фото',
			'login'     =>'Логин',
			'fio'       =>'Ф.И.О.',
            'firstName' =>'Имя',
            'middleName'=>'Отчество',
            'lastName'  =>'Фамилия',
			'phone'     =>'Телефон',
			'email'     =>'Электронная почта',
			'password'  =>'Пароль',
			'first_name'=>'Имя',
			'last_name' =>'Фамилия',
			'address'   =>'Адрес',
			'city'      =>'Город',
			'postcode'  =>'Почтовый индекс',
			'country'   =>'Страна',
			'status'    =>'Статус',
			'newsletter'=>'Рассылка',
			'birth'     =>'Дата рождения',
			'userID'    =>'ID',
			'userIP'    =>'IP',
		),
		'messages' => array(
			'Пользователь сохранен.',
			'Пользователь удален.',
			'Картинка удалена.',
		),
		'errors' => array(
			'Введите электронную почту',
			'Введите другую электронную почту',
			'Введите пароль',
			'Введите номер телефона',
			'Введите полное имя',
			'Введите фамилию',
			'Введите адрес',
			'Введите город',
			'Введите почтовый индекс',
			'Выберите страну',
			'Пользователь не найден',
			'Пользователю не были внесены изменения',
			'Введите логин',
			'Ваш логин не корректен, логин может состоять только из следующих символов: A-Z a-z 0-9',
			'Введите корректный номер телефона',
			'Картинка не сохранена',
            'Введите корректный email',
            'Пользователь не удален'
		),
	);
	
	$L['currency'] = array(
		'title'                 => 'Валюты',
		'setDefaultCurrency'    => 'Изменить основную валюту',
		'default'               => 'По умолчанию',
		'empty' => 'Нет валют',
		'form' => array(
  		    'title'     =>'Название валюты',
            'codeName'  =>'Краткое обозначение',
            'course'    => 'Курс'
		),
		'table' => array(
  		    'title'     => 'Название валюты',
            'codeName'  => 'Знак',
            'course'    => 'Курс'
		),
		'buttons' => array(
		    'changeDefaultCurrency' => 'Изменить основную валюту'
        ),
		'messages' => array(
			'saved'         => 'Валюта &laquo;{if isset($currency.title)}{$currency.title}{/if}&raquo; сохранена',
			'deleted'       => 'Валюта удалена',
			'confirmDelete' => 'Вы уверены, что хотите удалить валюту',
			'confirmSetDefaultCurrency' => 'Вы уверены, что хотите изменить основную валюту сайта на'
		),
		'errors' => array(
			'titleNull'     => 'Введите название валюты',
			'codeNameNull'  => 'Введите краткое обозначение валюты',
			'courseNull'    => 'Введите курс валюты',
		),
	);

	$L['logo'] = array(
		'title'    => 'Логотип',
		'logo'     => 'Логотип сайта',
		'add'      => 'Загрузить логотип',
		'change'   => 'Изменить логотип',
		'logoFile' => 'Имя файла',
		'logoUrl' => 'Путь',
		'logoExt' => 'Формат файла',
		'messages' => array(
			'Логотип загружен.',
            'Логотип удален.',
		),
		'errors'   => array(
			'Выберите пожалуйста файл.',
			'Не допустимый формат файла!',
			'Ошибка загрузки файла!',
			'Отсутствует кодировка версии языка сайта.',
			'Размер загружаемого файла велик!',
		),
	);
	
	$L['socials'] = array(
		'title'=>'Социальные сети',
		'name'=>'Название',
		'fileName'=>'Псевдоним',
		'icon'=>'Иконка',
		'url'=>'Ссылка',
		'visibleIconText'=>'Отобразить иконку и текст',
		'iconTable'=>'Иконка',
		'urlTable'=>'Ссылка',
		'add'=>'Добавить',
		'delete'=>'Удалить',
		'confirm'=>'Вы уверены, что хотите удалить?',
		'messages'=>array(
			'«{$social.name|default:""}» сохранен.',
			'Соц.сеть удалена.',
			'Изменения сохранены.',
            'Соц.сеть перемещена.',
		),
		'errors'=>array(
			'Введите название Социальной сети.',
            'Псевдоним не должен быть пустым:',
            '«{$social.fileName|default:""}» Уже существует:',
			'«{$social.name|default:""}» НЕ сохранен или не были изменены',
			'«{$social.name|default:""}» НЕ удаляется:',

		),
	);

	$L['orders'] = array(
		'title'     => 'Заказы',
		'general'   => '№ заказа',
		'invoce'    => 'Заказ',
		'status'    => 'Статус',
		'delete'    => 'Удалить',
		'statuses' => array(
    		'waiting'   => 'Ожидание оплаты',
			'rejected'  => 'Отвергнутая оплата',
			'confirmed' => 'Подтвержденная оплата',
		),
		'messages' => array(
			'Заказ сохранен.',
			'Заказ удален.',
		),
		'errors' => array(
			'Введите название заказ.',
			'Ошибка при удаление заказа.',
		),
	);

	$L['newsletterClass'] = array (
        'emailEmpty' => 'Поле email адреса не должно быть пустым.',
        'emailError' => 'Вы должны заполнить поле действительным адресом электронной почты',
        'successSub' => 'Вы успешно подписаны',
        'errorSql'   => 'Произошла ошибка. Пожалуйста, попробуйте еще раз',
        'emailSub'   => 'Это email уже подписан'
    );
  
    $L['langtimezones'] = array(
      'langtimezone' => array(
          'Pacific/Midway'       => '(GMT-11:00) Остров Мидуэй',
          'US/Samoa'             => "(GMT-11:00) Самоа",
          'US/Hawaii'            => "(GMT-10:00) Гавайи",
          'US/Alaska'            => "(GMT-09:00) Аляска",
          'US/Pacific'           => "(GMT-08:00) Тихоокеанское время (США и Канада)",
          'America/Tijuana'      => "(GMT-08:00) Тихуана",
          'US/Arizona'           => "(GMT-07:00) Аризона",
          'US/Mountain'          => "(GMT-07:00) Горное время (США и Канада)",
          'America/Chihuahua'    => "(GMT-07:00) Чихуахуа",
          'America/Mazatlan'     => "(GMT-07:00) Масатлан",
          'America/Mexico_City'  => "(GMT-06:00) Мехико",
          'America/Monterrey'    => "(GMT-06:00) Монтеррей",
          'US/Central'           => "(GMT-06:00) Центральное время (США и Канада)",
          'US/Eastern'           => "(GMT-05:00) Восточное время (США и Канада)",
          'US/East-Indiana'      => "(GMT-05:00) Индиана (Восток)",
          'America/Lima'         => "(GMT-05:00) Лима, Богота",
          'America/Caracas'      => "(GMT-04:30) Каракас",
          'Canada/Atlantic'      => "(GMT-04:00) Атлантическое время (Канада)",
          'America/La_Paz'       => "(GMT-04:00) Ла-Пас",
          'America/Santiago'     => "(GMT-04:00) Сантьяго",
          'Canada/Newfoundland'  => "(GMT-03:30) Ньюфаундленд",
          'America/Buenos_Aires' => "(GMT-03:00) Буэнос-Айрес",
          'America/Godthab'      => "(GMT-03:00) Гренландия",
          'Atlantic/Stanley'     => "(GMT-02:00) Стэнли",
          'Atlantic/Azores'      => "(GMT-01:00) Азорские острова",
          'Africa/Casablanca'    => "(GMT) Касабланка",
          'Europe/Dublin'        => "(GMT) Дублин",
          'Europe/Lisbon'        => "(GMT) Лиссабон",
          'Europe/London'        => "(GMT) Лондон",
          'Europe/Amsterdam'     => "(GMT+01:00) Амстердам",
          'Europe/Belgrade'      => "(GMT+01:00) Белград",
          'Europe/Berlin'        => "(GMT+01:00) Берлин",
          'Europe/Bratislava'    => "(GMT+01:00) Братислава",
          'Europe/Brussels'      => "(GMT+01:00) Брюссель",
          'Europe/Budapest'      => "(GMT+01:00) Будапешт",
          'Europe/Copenhagen'    => "(GMT+01:00) Копенгаген",
          'Europe/Madrid'        => "(GMT+01:00) Мадрид",
          'Europe/Paris'         => "(GMT+01:00) Париж",
          'Europe/Prague'        => "(GMT+01:00) Прага",
          'Europe/Rome'          => "(GMT+01:00) Рим",
          'Europe/Sarajevo'      => "(GMT+01:00) Сараево",
          'Europe/Stockholm'     => "(GMT+01:00) Стокгольм",
          'Europe/Vienna'        => "(GMT+01:00) Вена",
          'Europe/Warsaw'        => "(GMT+01:00) Варшава",
          'Europe/Zagreb'        => "(GMT+01:00) Загреб",
          'Europe/Athens'        => "(GMT+02:00) Афины",
          'Europe/Bucharest'     => "(GMT+02:00) Бухарест",
          'Europe/Helsinki'      => "(GMT+02:00) Хельсинки",
          'Europe/Istanbul'      => "(GMT+02:00) Стамбул",
          'Asia/Jerusalem'       => "(GMT+02:00) Иерусалим",
          'Europe/Kiev'          => "(GMT+02:00) Киев",
          'Europe/Minsk'         => "(GMT+02:00) Минск",
          'Europe/Riga'          => "(GMT+02:00) Рига",
          'Europe/Sofia'         => "(GMT+02:00) София",
          'Europe/Tallinn'       => "(GMT+02:00) Таллин",
          'Europe/Vilnius'       => "(GMT+02:00) Вильнюс",
          'Europe/Kaliningrad'   => "(GMT+02:00) Калининград",
          'Asia/Baghdad'         => "(GMT+03:00) Багдад",
          'Asia/Kuwait'          => "(GMT+03:00) Кувейт",
          'Africa/Nairobi'       => "(GMT+03:00) Найроби",
          'Asia/Tehran'          => "(GMT+03:30) Иран, Тегеран",
          'Europe/Moscow'        => "(GMT+03:00) Москва",
          'Europe/Volgograd'     => "(GMT+03:00) Волгоград",
          'Europe/Samara'        => "(GMT+04:00) Самара, Удмуртия",
          'Asia/Baku'            => "(GMT+04:00) Баку",
          'Asia/Muscat'          => "(GMT+04:00) Абу-Даби, Маскат",
          'Asia/Tbilisi'         => "(GMT+04:00) Тбилиси",
          'Asia/Yerevan'         => "(GMT+04:00) Ереван",
          'Asia/Kabul'           => "(GMT+04:30) Афганистан, Кабул",
          'Asia/Yekaterinburg'   => "(GMT+05:00) Екатеринбург, Пермь",
          'Asia/Tashkent'        => "(GMT+05:00) Ташкент, Карачи",
          'Asia/Kolkata'         => "(GMT+05:30) Бомбей, Калькутта, Мадрас, Нью-Дели, Коломбо",
          'Asia/Kathmandu'       => "(GMT+05:45) Катманду",
          'Asia/Almaty'          => "(GMT+06:00) Алматы, Астана",
          'Asia/Novosibirsk'     => "(GMT+06:00) Новосибирск",
          'Asia/Jakarta'         => "(GMT+07:00) Бангкок, Ханой, Джакарта",
          'Asia/Krasnoyarsk'     => "(GMT+07:00) Красноярск",
          'Asia/Hong_Kong'       => "(GMT+08:00) Гонконг, Чунцин",
          'Asia/Kuala_Lumpur'    => "(GMT+08:00) Куала-Лумпур",
          'Asia/Singapore'       => "(GMT+08:00) Сингапур",
          'Asia/Taipei'          => "(GMT+08:00) Тайбэй",
          'Asia/Ulaanbaatar'     => "(GMT+08:00) Улан-Батор",
          'Asia/Urumqi'          => "(GMT+08:00) Урумчи",
          'Asia/Irkutsk'         => "(GMT+08:00) Иркутск",
          'Asia/Seoul'           => "(GMT+09:00) Сеул",
          'Asia/Tokyo'           => "(GMT+09:00) Токио, Осака, Саппоро",
          'Australia/Adelaide'   => "(GMT+09:30) Аделаида",
          'Australia/Darwin'     => "(GMT+09:30) Дарвин",
          'Asia/Yakutsk'         => "(GMT+09:00) Якутск",
          'Australia/Brisbane'   => "(GMT+10:00) Брисбен",
          'Pacific/Port_Moresby' => "(GMT+10:00) Гуам, Порт-Морсби",
          'Australia/Sydney'     => "(GMT+10:00) Мельбурн, Сидней, Канберра",
          'Asia/Vladivostok'     => "(GMT+10:00) Владивосток",
          'Asia/Sakhalin'        => "(GMT+11:00) Сахалин",
          'Asia/Magadan'         => "(GMT+12:00) Магадан, Камчатка",
          'Pacific/Auckland'     => "(GMT+12:00) Окленд, Веллингтон",
          'Pacific/Fiji'         => "(GMT+12:00) Фиджи, Маршалловы о."
      ),
      'timezone' => array(
          'Pacific/Midway'       => '-11:0',
          'US/Samoa'             => "-11:0",
          'US/Hawaii'            => "-10:0",
          'US/Alaska'            => "-9:0",
          'US/Pacific'           => "-8:0",
          'America/Tijuana'      => "-8:0",
          'US/Arizona'           => "-7:0",
          'US/Mountain'          => "-7:0",
          'America/Chihuahua'    => "-7:0",
          'America/Mazatlan'     => "-7:0",
          'America/Mexico_City'  => "-6:0",
          'America/Monterrey'    => "-6:0",
          'US/Central'           => "-6:0",
          'US/Eastern'           => "-5:0",
          'US/East-Indiana'      => "-5:0",
          'America/Lima'         => "-5:0",
          'America/Caracas'      => "-4:-30",
          'Canada/Atlantic'      => "-4:0",
          'America/La_Paz'       => "-4:0",
          'America/Santiago'     => "-4:0",
          'Canada/Newfoundland'  => "-3:-30",
          'America/Buenos_Aires' => "-3:0",
          'America/Godthab'      => "-3:0",
          'Atlantic/Stanley'     => "-2:0",
          'Atlantic/Azores'      => "-1:0",
          'Africa/Casablanca'    => "0:0",
          'Europe/Dublin'        => "0:0",
          'Europe/Lisbon'        => "0:0",
          'Europe/London'        => "0:0",
          'Europe/Amsterdam'     => "1:0",
          'Europe/Belgrade'      => "1:0",
          'Europe/Berlin'        => "1:0",
          'Europe/Bratislava'    => "1:0",
          'Europe/Brussels'      => "1:0",
          'Europe/Budapest'      => "1:0",
          'Europe/Copenhagen'    => "1:0",
          'Europe/Madrid'        => "1:0",
          'Europe/Paris'         => "1:0",
          'Europe/Prague'        => "1:0",
          'Europe/Rome'          => "1:0",
          'Europe/Sarajevo'      => "1:0",
          'Europe/Stockholm'     => "1:0",
          'Europe/Vienna'        => "1:0",
          'Europe/Warsaw'        => "1:0",
          'Europe/Zagreb'        => "1:0",
          'Europe/Athens'        => "2:0",
          'Europe/Bucharest'     => "2:0",
          'Europe/Helsinki'      => "2:0",
          'Europe/Istanbul'      => "2:0",
          'Asia/Jerusalem'       => "2:0",
          'Europe/Kiev'          => "2:0",
          'Europe/Minsk'         => "2:0",
          'Europe/Riga'          => "2:0",
          'Europe/Sofia'         => "2:0",
          'Europe/Tallinn'       => "2:0",
          'Europe/Vilnius'       => "2:0",
          'Europe/Kaliningrad'   => "2:0",
          'Asia/Baghdad'         => "3:0",
          'Asia/Kuwait'          => "3:0",
          'Africa/Nairobi'       => "3:0",
          'Europe/Moscow'        => "3:0",
          'Europe/Volgograd'     => "3:0",
          'Asia/Tehran'          => "3:30",
          'Europe/Samara'        => "4:0",
          'Asia/Baku'            => "4:0",
          'Asia/Muscat'          => "4:0",
          'Asia/Tbilisi'         => "4:0",
          'Asia/Yerevan'         => "4:0",
          'Asia/Kabul'           => "4:30",
          'Asia/Yekaterinburg'   => "5:0",
          'Asia/Tashkent'        => "5:0",
          'Asia/Kolkata'         => "5:30",
          'Asia/Kathmandu'       => "5:45",
          'Asia/Almaty'          => "6:0",
          'Asia/Novosibirsk'     => "6:0",
          'Asia/Jakarta'         => "7:0",
          'Asia/Krasnoyarsk'     => "7:0",
          'Asia/Hong_Kong'       => "8:0",
          'Asia/Kuala_Lumpur'    => "8:0",
          'Asia/Singapore'       => "8:0",
          'Asia/Taipei'          => "8:0",
          'Asia/Ulaanbaatar'     => "8:0",
          'Asia/Urumqi'          => "8:0",
          'Asia/Irkutsk'         => "8:0",
          'Asia/Seoul'           => "9:0",
          'Asia/Tokyo'           => "9:0",
          'Australia/Adelaide'   => "9:30",
          'Australia/Darwin'     => "9:30",
          'Asia/Yakutsk'         => "9:0",
          'Australia/Brisbane'   => "10:0",
          'Pacific/Port_Moresby' => "10:0",
          'Australia/Sydney'     => "10:0",
          'Asia/Vladivostok'     => "10:0",
          'Asia/Sakhalin'        => "11:0",
          'Asia/Magadan'         => "12:0",
          'Pacific/Auckland'     => "12:0",
          'Pacific/Fiji'         => "12:0"
      )
  );

    $L['emoji_smileys_people']	=	"Смайлы и люди";
    $L['emoji_animals_nature']	=	"Животные и природа";
    $L['emoji_food_drink']		=	"Еда и напитки";
    $L['emoji_activities']		=	"Активность";
    $L['emoji_travel_places']	=	"Путешествия и места";
    $L['emoji_objects']			=	"Предметы";
    $L['emoji_symbols']			=	"Символы";
    $L['emoji_flags']			=	"Флаги";
    $L['emoji_last']		    =	"Недавно использованные";

  return $L;