<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Core\Config;
use Mnv\Core\Utilities\Cookie\Cookie;

/**
 * Class StatsDateSelector
 * @package Mnv\Admin\Controllers
 */
class StatsDateSelector
{

    /** @var array  */
    public array $simplePeriods = array();

    /** @var false|string  */
    public $dateStart;

    /** @var false|string  */
    public $dateEnd;

    /**
     * StatsDateSelector constructor.
     */
    public function __construct($noTimeAdjust = true, $dsCookieName = null)
    {
        global $smarty;

        if (empty($dsCookieName)) $dsCookieName = 'mainDateSelector';


        $dsCookie        = request()->cookie($dsCookieName);
        $newSimplePeriod = request('newSimplePeriod','');
        $newDateStart    = request('newDateStart', '');
        $newDateEnd      = request('newDateEnd', '');
        $simplePeriod = '';

//        print_r($dsCookie);

//        if (!empty($dsCookie)) $dsCookie = @unserialize($dsCookie);
        if (!empty($dsCookie)) $dsCookie = json_decode($dsCookie, true);
        if (!empty($newDateStart)) $this->dateStart = $newDateStart;
        if (!empty($newDateEnd)) $this->dateEnd = $newDateEnd;
        if (!empty($newSimplePeriod)) $simplePeriod = $newSimplePeriod;

        if (!empty($newDateStart) && !empty($newDateEnd)) {

            /* date range has been selected */
            unset($dsCookie['simplePeriod']);
            $dsCookie['dateStart'] = $newDateStart;
            $dsCookie['dateEnd']   = $newDateEnd;
            Cookie::setcookie($dsCookieName, json_encode($dsCookie, JSON_UNESCAPED_UNICODE), time() + 60*60*24*180);

        }
        else if(!empty($simplePeriod)) {

            /* predefined period has been selected */
            unset($dsCookie['dateStart']);
            unset($dsCookie['dateEnd']);
            $dsCookie['simplePeriod'] = $simplePeriod;
            Cookie::setcookie($dsCookieName, serialize($dsCookie), time() + 60*60*24*180);

        }
        elseif (!empty($dsCookie['dateStart']) && !empty($dsCookie['dateEnd'])) {

            /* predefined date range from cookie */
            $this->dateStart = $dsCookie['dateStart'];
            $this->dateEnd   = $dsCookie['dateEnd'];

        }
        elseif (!empty($dsCookie['simplePeriod'])) {

            /* predefined period from cookie */
            $simplePeriod = $dsCookie['simplePeriod'];

        }
        else {

            /* default period is "today" */
            $simplePeriod = 'alltime';
        }

        $this->simplePeriod($simplePeriod);

        if (empty($noTimeAdjust)) {
            $this->dateStart = adjustTime($this->dateStart . ' 00:00:00', true);
            $this->dateEnd   = adjustTime($this->dateEnd . ' 23:59:59', true);
        }

        $smarty->assign('dateDefault', '2022-01-01');
        $smarty->assign('dateStart', $this->dateStart);
        $smarty->assign('dateEnd', $this->dateEnd);

        $smarty->assign('simplePeriods', $this->simplePeriods);
    }

    /**
     * Установка времени за определенный период
     */
    public function simplePeriod($simplePeriod)
    {
        global $smarty;

        if (!empty($simplePeriod)) {
            switch ($simplePeriod){
                case 'yesterday':
                    $this->dateEnd = $this->dateStart = gmdate('Y-m-d', strtotime("-1 day " . Config::getValue('hour_adjustment')." hours ".Config::getValue('minute_adjustment')." minutes"));
                    break;
                case 'last7days':
                    $this->dateEnd = gmdate('Y-m-d', strtotime("" . Config::getValue('hour_adjustment') . " hours " . Config::getValue('minute_adjustment') . " minutes"));
                    $this->dateStart = gmdate('Y-m-d', strtotime("-1 week " . Config::getValue('hour_adjustment') . " hours " . Config::getValue('minute_adjustment') . " minutes"));
                    break;
                case 'thismonth':
                    $this->dateEnd = gmdate('Y-m-d', strtotime("" . Config::getValue('hour_adjustment') . " hours " . Config::getValue('minute_adjustment') . " minutes"));
                    $this->dateStart = gmdate('Y-m-01', strtotime("" . Config::getValue('hour_adjustment') . " hours " . Config::getValue('minute_adjustment') . " minutes"));
                    break;
                case 'lastmonth':
                    $this->dateEnd = gmdate('Y-m-d', mktime(Config::getValue('hour_adjustment'),Config::getValue('minute_adjustment'), 0, date('n'), 0));
                    $this->dateStart = gmdate('Y-m-01', strtotime("-1 month " . Config::getValue('hour_adjustment') . " hours " . Config::getValue('minute_adjustment') . " minutes"));
                    break;
                case 'alltime':
                    $this->dateEnd = gmdate('Y-m-d', strtotime("" . Config::getValue('hour_adjustment') . " hours " . Config::getValue('minute_adjustment') . " minutes"));
                    $this->dateStart = '2010-01-01';
                    break;
                case 'today':
                default:
                    $this->dateEnd = $this->dateStart = gmdate('Y-m-d', strtotime("" . Config::getValue('hour_adjustment') . " hours " . Config::getValue('minute_adjustment') . " minutes"));
                    break;
            }

            $this->simplePeriods = array(
                'today'     => lang('stats:periods:today'),
                'yesterday' => lang('stats:periods:yesterday'),
                'last7days' => lang('stats:periods:last7days'),
                'thismonth' => lang('stats:periods:thisMonth'),
                'lastmonth' => lang('stats:periods:lastMonth'),
                'alltime'   => lang('stats:periods:allTime'),
            );
            $smarty->assign('simplePeriod', $simplePeriod);

        } else {

            $this->simplePeriods = array(
                ''          => '',
                'today'     => lang('stats:periods:today'),
                'yesterday' => lang('stats:periods:yesterday'),
                'last7days' => lang('stats:periods:last7days'),
                'thismonth' => lang('stats:periods:thisMonth'),
                'lastmonth' => lang('stats:periods:lastMonth'),
                'alltime'   => lang('stats:periods:allTime'),
            );
            $smarty->assign('simplePeriod', '');

        }
    }
}
