<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Models\Shop\Colors;

/**
 * Class ProductColorsAdmin
 * @package Mnv\Admin\Controllers
 */
class ProductColorsAdmin extends AdminMnv
{

    /**
     * Вывод всех статей
     */
    public function fetch()
    {
        $colors = new Colors($this->request);

        /** title */
        $this->smarty->assign('title', 'Цвета');
        /** activeItem */
        $this->smarty->assign('activeItem', $this->module);
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);
        
        /** действия */
        if ($this->action == 'remove') {
            $result = $colors->remove()
                ? array('status' => 200, 'message' => 'Цвет удален', 'type' => 'success')
                : array('status' => 403, 'message' => 'Цвет НЕ удалена', 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        } else if ($this->action == 'reorder') {

            $i = 0;
            $colors->data = [];
            foreach ($colors->colorIds as $colorId) {
                $i++;
                $colors->id = $colorId;
                $colors->data['orderBy'] = $i;
                $colors->update($colors->data);
            }
            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        } else if ($this->action == 'status') {

            $result = $colors->status()
                ? array('data' => true, 'status' => $this->status, 'type' => 'success')
                : array('data' => false, 'status' => $this->status, 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        } else {

            $colors->filter = array_filter([
                'status'        => $this->status,
                'query'         => $this->query,
            ]);

            /** получение всех статей */
            $contents = collect($colors->all($this->limit, $this->page))->map(function ($item) use ($colors) {
                $item['statusName'] = lang('general:statuses:' . $item['status']);

                return $item;
            })->all();

            /** pagination */
            $colors->total();
            $pages = getPageNums($colors->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalColors', $colors->total);
            $this->smarty->assign('colors', $contents);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('page', $this->page);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions($this->module)) {
            return $this->smarty->fetch('views/shop/' . $this->module . '.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}