<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Payments;

/**
 * Class PaymentsAdmin
 * @package Mnv\Admin\Controllers
 */
class PaymentsAdmin extends AdminMnv
{

    public function fetch()
    {

        $payment = new Payments($this->request);

        $this->smarty->assign('activeItem','payments');
        $this->smarty->assign('title', lang('payments:title'));


        if ($this->action == 'remove') {
            $result = $payment->remove()
                ? array('status' => 200, 'message' => lang('payments:messages:payment_delete'), 'type' => 'success')
                : array('status' => 403, 'message' => lang('payments:errors:payment_not_delete'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        else if ($this->action == 'status') {

            $result = $payment->status()
                ? array('data' => true, 'status' => $payment->status, 'type' => 'success')
                : array('data' => false, 'status' => $payment->status, 'type' => 'error');
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }
        /** сортировка */
        else if ($this->action == 'reorder') {

            $i = 0;
            foreach ($payment->paymentIds as $paymentId) {
                $i++;
                $payment->id = $paymentId;
                $payment->data['orderBy'] = $i;
                $payment->update($payment->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }

        $payments = collect($payment->all($this->limit, $this->page))->map(function ($item) {
            $item['statusName']  = lang('general:statuses:' . $item['status']);

            return $item;
        })->all();

        $payment->total();
        $pageNums = getPageNums($payment->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('totalPayments', $payment->total);
        $this->smarty->assign('payments', $payments);
        $this->smarty->assign('pageNums', $pageNums);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('payments')) {
            return $this->smarty->fetch('views/payments/payments.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }

}