<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Models\Orders;

/**
 * Class OrdersAdmin
 * @package Mnv\Admin\Controllers
 */
class OrdersAdmin extends AdminMnv
{

    public function fetch()
    {

        $order = new Orders($this->request);

        $dateSelector = new StatsDateSelector(false, 'ordersDateSelector');
        $typeSelector = new StatsTypeSelector();
        $this->smarty->assign('filterTypeOptions', $typeSelector->get());
        $sections = array();

        $this->smarty->assign('activeItem','orders');
        $this->smarty->assign('title', lang('orders:title'));
        $this->smarty->assign('statuses', lang('orders:statuses'));

        $this->smarty->assign('sections', $sections);


        if ($this->action == 'remove') {
            $result = $order->remove()
                ? array('status' => 200, 'message' => lang('orders:messages:1'), 'type' => 'success')
                : array('status' => 403, 'message' => lang('orders:errors:1'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        else {

            /** фильтровать контента */
            $order->filter = array_filter([
                'dateStart'     => $dateSelector->dateStart,
                'dateEnd'       => $dateSelector->dateEnd,
                'status'        => $this->status,
                'query'         => $this->query,
            ]);

            /** получение всего контента */
            $orders = collect($order->all($this->limit, $this->page))->map(function ($item) {
                $item['statusName'] = lang('orders:statuses:' . $item['status']);
                $item['createdBy']  = langDate(adjustTime($item['createdBy'], false, 'd.m.Y'));
                $item['monthBy']    = langDate(adjustTime($item['createdBy'], false, 'd.m.Y'));
                $item['amount']     = number_format($item['amount'], 0, '.', ' ');

                return $item;
            })->all();


            /** pagination */
            $order->total();
            $pages = getPageNums($order->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalOrders', $order->total);
            $this->smarty->assign('orders', $orders);
            $this->smarty->assign('pageNums', $pages);

        }

//        $this->smarty->assign('page', $this->page);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('orders')) {
            return $this->smarty->fetch('views/orders/orders.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}
