<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\OrderStatus;

/**
 * Class OrderStatusesAdmin
 * @package Mnv\Admin\Controllers
 */
class OrderStatusesAdmin extends AdminMnv
{

    public function fetch()
    {
        $orderStatuses = new OrderStatus($this->request);

        $this->smarty->assign('activeItem','statuses');
        $this->smarty->assign('title', 'Статусы заказа');

       if ($this->action == 'save' || $this->action == 'apply') {
            if ($orderStatuses->prepare()) {
                $this->messages['saved'] = true;
            } else {
                $this->errors['not_saved'] = true;
            }
        }


        /** получение всех соц. сетей */
        $statuses = $orderStatuses->all(100, $this->page);

        $orderStatuses->total();
        $pages = getPageNums($orderStatuses->total, $this->page, $this->limit, 0, 4, 4, 0);

        /** вывод в шаблон результатов */
        $this->smarty->assign('statuses', $statuses);
        $this->smarty->assign('pageNums', $pages);


        /** Права доступа к данному шаблону */
        if ($this->permissions('statuses')) {
            return $this->smarty->fetch('views/orders/statuses.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}



