<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\FAQ;

/**
 * Class FAQAdmin
 * @package Mnv\Admin\Controllers
 */
class FAQAdmin extends AdminMnv
{

	public function fetch()
    {
        $faq = new FAQ($this->request);
        $this->smarty->assign('activeItem','faqs');
        $this->smarty->assign('title', 'FAQ');

        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        if ($this->action == 'add' || $this->action == 'edit') {
            $faq->edit()->gettingInfoAboutUsers();
        }
        else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($faq->data['question'])) $this->errors['question'] = true;

            if (empty($this->errors)) {
                if ($faq->prepare($faq->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $faq->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/faqs");
            }

        }

        $this->smarty->assign('faq', $faq->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        if ($this->permissions('faqs')) {
            return $this->smarty->fetch('views/faqs/faq.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}