<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Test\Logger;

/**
 * Class AssetsAdmin
 * @package Mnv\Admin\Controllers
 */
class AssetsAdmin extends AdminMnv
{
    protected $template;

    public function fetch()
    {

        $this->smarty->assign('activeItem','asset');
        $this->smarty->assign('title', lang('templates:title'));

        $this->template = $this->request->get('template', '');


        if ($this->action === 'save') {
            if (!empty($this->template['isNew'])) {
                if (empty($this->template['fileName'])) $this->errors['fileName'] = true;
                $this->template['fileName'] = str_replace(' ', '_', $this->template['fileName']);
                if (preg_match('/[^0-9a-zA-Z\-_\. ]/i', $this->template['fileName'])) $this->errors['fileNameCharacters'] = true;
                $templates = searchDir(THEME_ROOT, '*.tpl');
                if (in_array($this->template['fileName'].'.tpl', $templates)) $this->errors['fileNameExists'] = true;
            }
            if (empty($this->errors)) {
                if (!empty($this->template['isNew'])) {
                    $this->template['fileName'] = $this->template['fileName'] . '.tpl';
                }
                if ($this->templates->save($this->template)) {
                    $this->messages['saved_new_file'] = true;
                    Logger::init()->info("Создан новый шаблон «" . $this->template['fileName'] . "».", $this->manager['userId'])->save();
                } else {
                    $this->errors['not_saved'] = true;
                }
            } else {
                $this->smarty->assign('template', $this->template);
            }
        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('asset')) {
            return $this->smarty->fetch('views/templates/assets.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}








	
	
	
	
	