<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\AdsBanner;

/**
 * Class AdsBannersAdmin
 * @package Mnv\Admin\Controllers
 */
class AdsBannersAdmin extends AdminMnv
{
    public function fetch()
    {

        $banner = new AdsBanner($this->request);

        $this->smarty->assign('activeItem','banners');
        $this->smarty->assign('title', lang('banners:sectionName'));

        if ($this->action == 'remove') {
              $result = $banner->remove()
                ? array('status' => 200, 'message' => lang('banners:messages:1'), 'type' => 'success')
                : array('status' => 403, 'message' => 'Ошибка при удаление банера', 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        $banners = $banner->all($this->limit, $this->page);

        /** pagination */
        $banner->total();
        $pages = getPageNums($banner->total, $this->page, $this->limit, 0, 4, 4, 0);

        /** вывод в шаблон результатов */
        $this->smarty->assign('totalBanners', $banner->total);
        $this->smarty->assign('adBanners', $banners);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('ads')) {
            return $this->smarty->fetch('views/ads/banners.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }
}


